/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.mysql;

import java.util.Arrays;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class MySQLConfiguration {
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String database;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    private final boolean useSSL;

    @NotNull
    public static MySQLConfiguration fromSection(@NotNull ConfigurationSection section) {
        section.checkForUnknownKey(Arrays.asList("enabled", "host", "port", "database", "username", "password", "useSSL"));
        return new MySQLConfiguration(section.getString("host", "127.0.0.1"), section.getInt("port", 3306), section.getString("database", "tab"), section.getString("username", "user"), section.getString("password", "password"), section.getBoolean("useSSL", true));
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getDatabase() {
        return this.database;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public MySQLConfiguration(@NotNull String host, int port, @NotNull String database, @NotNull String username, @NotNull String password, boolean useSSL) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
    }
}

