/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.Collections;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.CpuManager;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.belowname.BelowName;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.playerlistobjective.YellowNumber;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.types.EntryAddListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NickCompatibility
extends TabFeature
implements EntryAddListener {
    @Nullable
    private final NameTag nameTags = TAB.getInstance().getNameTagManager();
    @Nullable
    private final BelowName belowname = (BelowName)TAB.getInstance().getFeatureManager().getFeature("BelowName");
    @Nullable
    private final YellowNumber yellownumber = (YellowNumber)TAB.getInstance().getFeatureManager().getFeature("YellowNumber");
    @Nullable
    private final RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");

    @Override
    public synchronized void onEntryAdd(TabPlayer packetReceiver, UUID id, String name) {
        TabPlayer packetPlayer = TAB.getInstance().getPlayerByTabListUUID(id);
        if (packetPlayer != null && packetPlayer == packetReceiver && !packetPlayer.getNickname().equals(name)) {
            packetPlayer.setNickname(name);
            TAB.getInstance().debug("Processing name change of player " + packetPlayer.getName() + " to " + name);
            this.processNameChange(packetPlayer);
        }
        if (this.redis != null) {
            RedisPlayer redisPlayer = this.redis.getRedisPlayers().get(id);
            if (redisPlayer == null) {
                return;
            }
            if (!redisPlayer.getNickname().equals(name)) {
                redisPlayer.setNickname(name);
                TAB.getInstance().debug("Processing name change of redis player " + redisPlayer.getName() + " to " + name);
                this.processNameChange(redisPlayer);
            }
        }
    }

    public void processNameChange(@NotNull TabPlayer player) {
        CpuManager cpu = TAB.getInstance().getCpu();
        cpu.getProcessingThread().execute(new TimedCaughtTask(cpu, () -> {
            if (this.nameTags != null && !player.teamData.isDisabled()) {
                for (TabPlayer viewer : this.nameTags.getOnlinePlayers().getPlayers()) {
                    TabComponent prefix = (TabComponent)this.nameTags.getCache().get(player.teamData.prefix.getFormat(viewer));
                    viewer.getScoreboard().unregisterTeam(player.sortingData.getShortTeamName());
                    viewer.getScoreboard().registerTeam(player.sortingData.getShortTeamName(), prefix, (TabComponent)this.nameTags.getCache().get(player.teamData.suffix.getFormat(viewer)), this.nameTags.getTeamVisibility(player, viewer) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER, player.teamData.getCollisionRule() ? Scoreboard.CollisionRule.ALWAYS : Scoreboard.CollisionRule.NEVER, Collections.singletonList(player.getNickname()), this.nameTags.getTeamOptions(), prefix.getLastColor().getLegacyColor());
                }
            }
            if (this.belowname != null) {
                this.belowname.processNicknameChange(player);
            }
            if (this.yellownumber != null) {
                this.yellownumber.processNicknameChange(player);
            }
        }, this.getFeatureName(), "Compatibility with nick plugins"));
    }

    private void processNameChange(RedisPlayer player) {
        CpuManager cpu = TAB.getInstance().getCpu();
        cpu.getProcessingThread().execute(new TimedCaughtTask(cpu, () -> {
            if (this.nameTags != null) {
                String teamName = player.getTeamName();
                TabPlayer[] tabPlayerArray = this.nameTags.getOnlinePlayers().getPlayers();
                int n = tabPlayerArray.length;
                for (int i = 0; i < n; ++i) {
                    TabPlayer viewer = tabPlayerArray[i];
                    viewer.getScoreboard().unregisterTeam(teamName);
                    TabComponent prefix = (TabComponent)this.nameTags.getCache().get(player.getTagPrefix());
                    viewer.getScoreboard().registerTeam(teamName, prefix, (TabComponent)this.nameTags.getCache().get(player.getTagSuffix()), player.getNameVisibility(), Scoreboard.CollisionRule.ALWAYS, Collections.singletonList(player.getNickname()), this.nameTags.getTeamOptions(), prefix.getLastColor().getLegacyColor());
                }
            }
            if (this.belowname != null) {
                for (TabPlayer all : this.belowname.getOnlinePlayers().getPlayers()) {
                    all.getScoreboard().setScore("TAB-BelowName", player.getNickname(), player.getBelowNameNumber(), null, player.getBelowNameFancy());
                }
            }
            if (this.yellownumber != null) {
                for (TabPlayer all : this.yellownumber.getOnlinePlayers().getPlayers()) {
                    all.getScoreboard().setScore("TAB-PlayerList", player.getNickname(), player.getPlayerlistNumber(), null, player.getPlayerlistFancy());
                }
            }
        }, this.getFeatureName(), "Compatibility with nick plugins"));
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Nick compatibility";
    }
}

