/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.GameModeListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class SpectatorFix
extends TabFeature
implements JoinListener,
GameModeListener,
Loadable,
UnLoadable,
ServerSwitchListener,
WorldSwitchListener,
VanishListener,
CustomThreaded {
    private final ThreadExecutor customThread = new ThreadExecutor("TAB Spectator Fix Thread");

    private void updatePlayer(@NotNull TabPlayer viewer, boolean realGameMode, boolean mutually) {
        for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
            if (viewer == target) continue;
            if (target.getGamemode() == 3 && !viewer.hasPermission("tab.spectatorbypass")) {
                viewer.getTabList().updateGameMode(target.getTablistId(), realGameMode ? target.getGamemode() : 0);
            }
            if (!mutually || viewer.getGamemode() != 3 || target.hasPermission("tab.spectatorbypass")) continue;
            target.getTabList().updateGameMode(viewer.getTablistId(), realGameMode ? viewer.getGamemode() : 0);
        }
    }

    @Override
    public void onGameModeChange(@NotNull TabPlayer player) {
        if (player.getGamemode() != 3) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.hasPermission("tab.spectatorbypass") || player == viewer || !player.server.equals(viewer.server)) continue;
            viewer.getTabList().updateGameMode(player.getTablistId(), 0);
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer p) {
        this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> this.updatePlayer(p, false, true), this.getFeatureName(), "Player Join"), 100);
    }

    @Override
    public void load() {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.updatePlayer(viewer, false, false);
        }
    }

    @Override
    public void unload() {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.updatePlayer(viewer, true, false);
        }
    }

    @Override
    public void onServerChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                this.updatePlayer(all, false, true);
            }
        }, this.getFeatureName(), "Server Switch"), 300);
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        if (changed.getGamemode() != 3) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer == changed || viewer.hasPermission("tab.spectatorbypass")) continue;
            viewer.getTabList().updateGameMode(changed.getTablistId(), 0);
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        if (player.isVanished() || player.getGamemode() != 3) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer == player || viewer.hasPermission("tab.spectatorbypass")) continue;
            viewer.getTabList().updateGameMode(player.getTablistId(), 0);
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Spectator fix";
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }
}

