/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.belowname;

import java.util.HashMap;
import java.util.Map;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.belowname.BelowNameConfiguration;
import me.neznamy.tab.shared.features.belowname.BelowNameTitleRefresher;
import me.neznamy.tab.shared.features.belowname.BelowNameUpdateRedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RedisFeature;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.OnlinePlayers;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BelowName
extends RefreshableFeature
implements JoinListener,
QuitListener,
Loadable,
WorldSwitchListener,
ServerSwitchListener,
CustomThreaded,
RedisFeature,
VanishListener {
    public static final String OBJECTIVE_NAME = "TAB-BelowName";
    private final StringToComponentCache cache = new StringToComponentCache("BelowName", 1000);
    private final ThreadExecutor customThread = new ThreadExecutor("TAB Belowname Objective Thread");
    private OnlinePlayers onlinePlayers;
    private final BelowNameConfiguration configuration;
    private final BelowNameTitleRefresher textRefresher = new BelowNameTitleRefresher(this, this.customThread);
    private final DisableChecker disableChecker;
    @Nullable
    private final RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");

    public BelowName(@NotNull BelowNameConfiguration configuration) {
        this.configuration = configuration;
        this.disableChecker = new DisableChecker(this, Condition.getCondition(configuration.getDisableCondition()), this::onDisableConditionChange, p -> p.belowNameData.disabled);
        TAB.getInstance().getFeatureManager().registerFeature("BelowName-Condition", this.disableChecker);
        TAB.getInstance().getFeatureManager().registerFeature("BelowNameText", this.textRefresher);
        if (this.redis != null) {
            this.redis.registerMessage("belowname", BelowNameUpdateRedisPlayer.class, () -> new BelowNameUpdateRedisPlayer(this));
        }
    }

    @Override
    public void load() {
        this.onlinePlayers = new OnlinePlayers(TAB.getInstance().getOnlinePlayers());
        HashMap<TabPlayer, Integer> values = new HashMap<TabPlayer, Integer>();
        for (TabPlayer loaded : this.onlinePlayers.getPlayers()) {
            this.loadProperties(loaded);
            if (this.disableChecker.isDisableConditionMet(loaded)) {
                loaded.belowNameData.disabled.set(true);
            } else {
                this.register(loaded);
            }
            values.put(loaded, this.getValue(loaded));
            if (this.redis == null) continue;
            this.redis.sendMessage(new BelowNameUpdateRedisPlayer(this, loaded.getTablistId(), (Integer)values.get(loaded), loaded.belowNameData.numberFormat.get()));
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            for (Map.Entry entry : values.entrySet()) {
                TabPlayer target = (TabPlayer)entry.getKey();
                if (!this.sameServerAndWorld(viewer, target)) continue;
                this.setScore(viewer, target, (Integer)entry.getValue(), target.belowNameData.numberFormat.getFormat(viewer));
            }
        }
    }

    private void loadProperties(@NotNull TabPlayer player) {
        player.belowNameData.score = new Property(this, player, this.configuration.getValue());
        player.belowNameData.numberFormat = new Property(this, player, this.configuration.getFancyValue());
        player.belowNameData.text = new Property(this.textRefresher, player, this.configuration.getTitle());
        player.belowNameData.defaultNumberFormat = new Property(this.textRefresher, player, this.configuration.getFancyValueDefault());
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.onlinePlayers.addPlayer(connectedPlayer);
        this.loadProperties(connectedPlayer);
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.belowNameData.disabled.set(true);
        } else {
            this.register(connectedPlayer);
        }
        int number = this.getValue(connectedPlayer);
        Property fancy = connectedPlayer.belowNameData.numberFormat;
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            if (!this.sameServerAndWorld(connectedPlayer, all)) continue;
            this.setScore(all, connectedPlayer, number, fancy.getFormat(all));
            if (all == connectedPlayer) continue;
            this.setScore(connectedPlayer, all, this.getValue(all), all.belowNameData.numberFormat.getFormat(connectedPlayer));
        }
        if (this.redis != null) {
            this.redis.sendMessage(new BelowNameUpdateRedisPlayer(this, connectedPlayer.getTablistId(), this.getValue(connectedPlayer), connectedPlayer.belowNameData.numberFormat.get()));
            if (connectedPlayer.belowNameData.disabled.get()) {
                return;
            }
            for (RedisPlayer redisPlayer : this.redis.getRedisPlayers().values()) {
                if (redisPlayer.getBelowNameFancy() == null) continue;
                connectedPlayer.getScoreboard().setScore(OBJECTIVE_NAME, redisPlayer.getNickname(), redisPlayer.getBelowNameNumber(), null, redisPlayer.getBelowNameFancy());
            }
        }
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        if (disabledNow) {
            p.getScoreboard().unregisterObjective(OBJECTIVE_NAME);
        } else {
            this.register(p);
            for (TabPlayer all : this.onlinePlayers.getPlayers()) {
                if (!this.sameServerAndWorld(p, all)) continue;
                this.setScore(p, all, this.getValue(all), all.belowNameData.numberFormat.getFormat(p));
            }
            if (this.redis != null) {
                this.redis.sendMessage(new BelowNameUpdateRedisPlayer(this, p.getTablistId(), this.getValue(p), p.belowNameData.numberFormat.get()));
                for (RedisPlayer redisPlayer : this.redis.getRedisPlayers().values()) {
                    if (redisPlayer.getBelowNameFancy() == null) continue;
                    p.getScoreboard().setScore(OBJECTIVE_NAME, redisPlayer.getNickname(), redisPlayer.getBelowNameNumber(), null, redisPlayer.getBelowNameFancy());
                }
            }
        }
    }

    public int getValue(@NotNull TabPlayer p) {
        String string = p.belowNameData.score.updateAndGet();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            try {
                int value = (int)Math.round(Double.parseDouble(string));
                TAB.getInstance().getConfigHelper().runtime().floatInBelowName(p, this.configuration.getValue(), string);
                return value;
            }
            catch (NumberFormatException e2) {
                TAB.getInstance().getConfigHelper().runtime().invalidNumberForBelowName(p, this.configuration.getValue(), string);
                return 0;
            }
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating BelowName number";
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        if (refreshed.belowNameData.score == null) {
            return;
        }
        int number = this.getValue(refreshed);
        Property fancy = refreshed.belowNameData.numberFormat;
        fancy.update();
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            if (!this.sameServerAndWorld(viewer, refreshed)) continue;
            this.setScore(viewer, refreshed, number, fancy.getFormat(viewer));
        }
        if (this.redis != null) {
            this.redis.sendMessage(new BelowNameUpdateRedisPlayer(this, refreshed.getTablistId(), number, fancy.get()));
        }
    }

    private void register(@NotNull TabPlayer player) {
        player.getScoreboard().registerObjective(Scoreboard.DisplaySlot.BELOW_NAME, OBJECTIVE_NAME, (TabComponent)this.cache.get(player.belowNameData.text.updateAndGet()), Scoreboard.HealthDisplay.INTEGER, (TabComponent)this.cache.get(player.belowNameData.defaultNumberFormat.updateAndGet()));
    }

    public void setScore(@NotNull TabPlayer viewer, @NotNull TabPlayer scoreHolder, int value, @NotNull String fancyDisplay) {
        if (viewer.belowNameData.disabled.get()) {
            return;
        }
        if (!TAB.getInstance().getPlatform().canSee(viewer, scoreHolder)) {
            return;
        }
        viewer.getScoreboard().setScore(OBJECTIVE_NAME, scoreHolder.getNickname(), value, null, (TabComponent)this.cache.get(fancyDisplay));
    }

    private boolean sameServerAndWorld(@NotNull TabPlayer player1, @NotNull TabPlayer player2) {
        return player1.server.equals(player2.server) && player1.world.equals(player2.world);
    }

    @Override
    public void onServerChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        this.updatePlayer(changed);
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        this.updatePlayer(changed);
    }

    private void updatePlayer(@NotNull TabPlayer player) {
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            if (!this.sameServerAndWorld(all, player)) continue;
            this.setScore(player, all, this.getValue(all), all.belowNameData.numberFormat.getFormat(player));
            if (all == player) continue;
            this.setScore(all, player, this.getValue(player), player.belowNameData.numberFormat.getFormat(all));
        }
    }

    public void processNicknameChange(@NotNull TabPlayer player) {
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            int value = this.getValue(player);
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                this.setScore(viewer, player, value, player.belowNameData.numberFormat.get());
            }
        }, this.getFeatureName(), "Processing nickname change"));
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        this.onlinePlayers.removePlayer(disconnectedPlayer);
    }

    @Override
    public void onRedisLoadRequest() {
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            this.redis.sendMessage(new BelowNameUpdateRedisPlayer(this, all.getTablistId(), this.getValue(all), all.belowNameData.numberFormat.get()));
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "BelowName";
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        if (player.isVanished()) {
            return;
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            this.setScore(viewer, player, this.getValue(player), player.belowNameData.numberFormat.getFormat(viewer));
        }
    }

    public StringToComponentCache getCache() {
        return this.cache;
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    public OnlinePlayers getOnlinePlayers() {
        return this.onlinePlayers;
    }
}

