/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.belowname;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.features.belowname.BelowName;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class BelowNameUpdateRedisPlayer
extends RedisMessage {
    @NotNull
    private final BelowName feature;
    private UUID playerId;
    private int value;
    private String fancyValue;

    @Override
    @NotNull
    public ThreadExecutor getCustomThread() {
        return this.feature.getCustomThread();
    }

    @Override
    public void write(@NotNull ByteArrayDataOutput out) {
        this.writeUUID(out, this.playerId);
        out.writeInt(this.value);
        out.writeUTF(this.fancyValue);
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in) {
        this.playerId = this.readUUID(in);
        this.value = in.readInt();
        this.fancyValue = in.readUTF();
    }

    @Override
    public void process(@NotNull RedisSupport redisSupport) {
        RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
        if (target == null) {
            TAB.getInstance().getErrorManager().printError("Unable to process Belowname objective update of redis player " + this.playerId + ", because no such player exists", null);
            return;
        }
        if (target.getBelowNameFancy() == null) {
            TAB.getInstance().debug("Processing belowname objective join of redis player " + target.getName());
        }
        target.setBelowNameNumber(this.value);
        target.setBelowNameFancy((TabComponent)this.feature.getCache().get(this.fancyValue));
        for (TabPlayer viewer : this.feature.getOnlinePlayers().getPlayers()) {
            if (viewer.belowNameData.disabled.get()) continue;
            viewer.getScoreboard().setScore("TAB-BelowName", target.getNickname(), target.getBelowNameNumber(), null, target.getBelowNameFancy());
        }
    }

    public BelowNameUpdateRedisPlayer(@NotNull BelowName feature) {
        if (feature == null) {
            throw new NullPointerException("feature is marked non-null but is null");
        }
        this.feature = feature;
    }

    public BelowNameUpdateRedisPlayer(@NotNull BelowName feature, UUID playerId, int value, String fancyValue) {
        if (feature == null) {
            throw new NullPointerException("feature is marked non-null but is null");
        }
        this.feature = feature;
        this.playerId = playerId;
        this.value = value;
        this.fancyValue = fancyValue;
    }
}

