/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.features.bossbar.BossBarConfiguration;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class BossBarLine
implements BossBar {
    private final BossBarManagerImpl manager;
    private final String name;
    private final Condition displayCondition;
    private final UUID uniqueId = UUID.randomUUID();
    private String style;
    private String color;
    private String title;
    private String progress;
    private final boolean announcementBar;
    private final Set<TabPlayer> players = new HashSet<TabPlayer>();
    private final TextRefresher textRefresher;
    private final ProgressRefresher progressRefresher;
    private final ColorRefresher colorRefresher;
    private final StyleRefresher styleRefresher;

    public BossBarLine(@NonNull BossBarManagerImpl manager, @NonNull String name, @NonNull BossBarConfiguration.BossBarDefinition configuration) {
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.manager = manager;
        this.name = name;
        this.displayCondition = Condition.getCondition(configuration.getDisplayCondition());
        if (this.displayCondition != null) {
            manager.addUsedPlaceholder(TabConstants.Placeholder.condition(this.displayCondition.getName()));
        }
        this.color = configuration.getColor();
        this.style = configuration.getStyle();
        this.title = configuration.getText();
        this.progress = configuration.getProgress();
        this.announcementBar = configuration.isAnnouncementOnly();
        this.textRefresher = new TextRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarTitle(name), this.textRefresher);
        this.progressRefresher = new ProgressRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarProgress(name), this.progressRefresher);
        this.colorRefresher = new ColorRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarColor(name), this.colorRefresher);
        this.styleRefresher = new StyleRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarStyle(name), this.styleRefresher);
    }

    public boolean isConditionMet(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (this.displayCondition == null) {
            return true;
        }
        return this.displayCondition.isMet(p);
    }

    @NotNull
    public BarColor parseColor(@NotNull TabPlayer player, @NonNull String color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        try {
            return BarColor.valueOf(color);
        }
        catch (IllegalArgumentException e) {
            TAB.getInstance().getConfigHelper().runtime().invalidBossBarProperty(this, color, player.bossbarData.visibleBossBars.get((Object)this).colorProperty.getCurrentRawValue(), player, "color", "one of the pre-defined values " + Arrays.toString((Object[])BarColor.values()));
            return BarColor.PURPLE;
        }
    }

    @NotNull
    public BarStyle parseStyle(@NotNull TabPlayer player, @NonNull String style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        try {
            return BarStyle.valueOf(style);
        }
        catch (IllegalArgumentException e) {
            TAB.getInstance().getConfigHelper().runtime().invalidBossBarProperty(this, style, player.bossbarData.visibleBossBars.get((Object)this).styleProperty.getCurrentRawValue(), player, "style", "one of the pre-defined values " + Arrays.toString((Object[])BarStyle.values()));
            return BarStyle.PROGRESS;
        }
    }

    public float parseProgress(@NotNull TabPlayer player, @NotNull String progress) {
        try {
            float value = Float.parseFloat(progress);
            if (value < 0.0f) {
                value = 0.0f;
            }
            if (value > 100.0f) {
                value = 100.0f;
            }
            return value;
        }
        catch (NumberFormatException e) {
            TAB.getInstance().getConfigHelper().runtime().invalidBossBarProperty(this, progress, player.bossbarData.visibleBossBars.get((Object)this).progressProperty.getCurrentRawValue(), player, "progress", "a number between 0 and 100");
            return 100.0f;
        }
    }

    public void removePlayerRaw(@NotNull TabPlayer player) {
        this.players.remove(player);
    }

    @Override
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        for (TabPlayer p : this.players) {
            p.bossbarData.visibleBossBars.get((Object)this).textProperty.changeRawValue(title);
            p.getBossBar().update(this.uniqueId, (TabComponent)this.manager.getCache().get(p.bossbarData.visibleBossBars.get((Object)this).textProperty.get()));
        }
    }

    @Override
    public void setProgress(@NonNull String progress) {
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        if (this.progress.equals(progress)) {
            return;
        }
        this.progress = progress;
        for (TabPlayer p : this.players) {
            p.bossbarData.visibleBossBars.get((Object)this).progressProperty.changeRawValue(progress);
            p.getBossBar().update(this.uniqueId, this.parseProgress(p, p.bossbarData.visibleBossBars.get((Object)this).progressProperty.get()) / 100.0f);
        }
    }

    @Override
    public void setProgress(float progress) {
        this.setProgress(String.valueOf(progress));
    }

    @Override
    public void setColor(@NonNull String color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (this.color.equals(color)) {
            return;
        }
        this.color = color;
        for (TabPlayer p : this.players) {
            p.bossbarData.visibleBossBars.get((Object)this).colorProperty.changeRawValue(color);
            p.getBossBar().update(this.uniqueId, this.parseColor(p, p.bossbarData.visibleBossBars.get((Object)this).colorProperty.get()));
        }
    }

    @Override
    public void setColor(@NonNull BarColor color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.setColor(color.toString());
    }

    @Override
    public void setStyle(@NonNull String style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        if (this.style.equals(style)) {
            return;
        }
        this.style = style;
        for (TabPlayer p : this.players) {
            p.bossbarData.visibleBossBars.get((Object)this).styleProperty.changeRawValue(style);
            p.getBossBar().update(this.uniqueId, this.parseStyle(p, p.bossbarData.visibleBossBars.get((Object)this).styleProperty.get()));
        }
    }

    @Override
    public void setStyle(@NonNull BarStyle style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.setStyle(style.toString());
    }

    @Override
    public void addPlayer(@NonNull me.neznamy.tab.api.TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        TabPlayer player = (TabPlayer)p;
        if (player.bossbarData.visibleBossBars.containsKey(this)) {
            return;
        }
        BossBarManagerImpl.BossBarProperties properties = new BossBarManagerImpl.BossBarProperties(new Property(this.textRefresher, player, this.title), new Property(this.progressRefresher, player, this.progress), new Property(this.colorRefresher, player, this.color), new Property(this.styleRefresher, player, this.style));
        player.bossbarData.visibleBossBars.put(this, properties);
        player.getBossBar().create(this.uniqueId, (TabComponent)this.manager.getCache().get(properties.textProperty.get()), this.parseProgress(player, properties.progressProperty.get()) / 100.0f, this.parseColor(player, properties.colorProperty.get()), this.parseStyle(player, properties.styleProperty.get()));
        this.players.add(player);
    }

    @Override
    public void removePlayer(@NonNull me.neznamy.tab.api.TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        TabPlayer player = (TabPlayer)p;
        if (!player.bossbarData.visibleBossBars.containsKey(this)) {
            return;
        }
        this.players.remove(player);
        player.bossbarData.visibleBossBars.remove(this);
        player.getBossBar().remove(this.uniqueId);
    }

    @Override
    @NotNull
    public List<me.neznamy.tab.api.TabPlayer> getPlayers() {
        return new ArrayList<me.neznamy.tab.api.TabPlayer>(this.players);
    }

    @Override
    public boolean containsPlayer(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return ((TabPlayer)player).bossbarData.visibleBossBars.containsKey(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public boolean isAnnouncementBar() {
        return this.announcementBar;
    }

    private class TextRefresher
    extends RefreshableFeature
    implements CustomThreaded {
        private TextRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!refreshed.bossbarData.visibleBossBars.containsKey(BossBarLine.this)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, (TabComponent)BossBarLine.this.manager.getCache().get(refreshed.bossbarData.visibleBossBars.get((Object)BossBarLine.this).textProperty.updateAndGet()));
        }

        @Override
        @NotNull
        public ThreadExecutor getCustomThread() {
            return BossBarLine.this.manager.getCustomThread();
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating text";
        }
    }

    private class ProgressRefresher
    extends RefreshableFeature
    implements CustomThreaded {
        private ProgressRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!refreshed.bossbarData.visibleBossBars.containsKey(BossBarLine.this)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, BossBarLine.this.parseProgress(refreshed, refreshed.bossbarData.visibleBossBars.get((Object)BossBarLine.this).progressProperty.updateAndGet()) / 100.0f);
        }

        @Override
        @NotNull
        public ThreadExecutor getCustomThread() {
            return BossBarLine.this.manager.getCustomThread();
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating progress";
        }
    }

    private class ColorRefresher
    extends RefreshableFeature
    implements CustomThreaded {
        private ColorRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!refreshed.bossbarData.visibleBossBars.containsKey(BossBarLine.this)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, BossBarLine.this.parseColor(refreshed, refreshed.bossbarData.visibleBossBars.get((Object)BossBarLine.this).colorProperty.updateAndGet()));
        }

        @Override
        @NotNull
        public ThreadExecutor getCustomThread() {
            return BossBarLine.this.manager.getCustomThread();
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating color";
        }
    }

    private class StyleRefresher
    extends RefreshableFeature
    implements CustomThreaded {
        private StyleRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!refreshed.bossbarData.visibleBossBars.containsKey(BossBarLine.this)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, BossBarLine.this.parseStyle(refreshed, refreshed.bossbarData.visibleBossBars.get((Object)BossBarLine.this).styleProperty.updateAndGet()));
        }

        @Override
        @NotNull
        public ThreadExecutor getCustomThread() {
            return BossBarLine.this.manager.getCustomThread();
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating style";
        }
    }
}

