/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.api.bossbar.BossBarManager;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.bossbar.BossBarConfiguration;
import me.neznamy.tab.shared.features.bossbar.BossBarLine;
import me.neznamy.tab.shared.features.types.CommandListener;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;

public class BossBarManagerImpl
extends RefreshableFeature
implements BossBarManager,
JoinListener,
CommandListener,
Loadable,
QuitListener,
CustomThreaded {
    private final StringToComponentCache cache = new StringToComponentCache("BossBar", 1000);
    private final ThreadExecutor customThread = new ThreadExecutor("TAB BossBar Thread");
    private final List<String> defaultBars = new ArrayList<String>();
    private final Map<String, BossBar> registeredBossBars = new LinkedHashMap<String, BossBar>();
    protected BossBar[] lineValues;
    private final BossBarConfiguration configuration;
    private final String toggleOnMessage = TAB.getInstance().getConfiguration().getMessages().getBossBarOn();
    private final String toggleOffMessage = TAB.getInstance().getConfiguration().getMessages().getBossBarOff();
    private final List<BossBar> announcedBossBars = new ArrayList<BossBar>();
    private final List<String> bossBarOffPlayers;
    private long announceEndTime;

    public BossBarManagerImpl(@NonNull BossBarConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
        this.bossBarOffPlayers = configuration.isRememberToggleChoice() ? TAB.getInstance().getConfiguration().getPlayerDataFile().getStringList("bossbar-off", new ArrayList<String>()) : Collections.emptyList();
        for (Map.Entry<String, BossBarConfiguration.BossBarDefinition> entry : configuration.getBars().entrySet()) {
            String name = entry.getKey();
            this.registeredBossBars.put(name, new BossBarLine(this, name, entry.getValue()));
            if (entry.getValue().isAnnouncementOnly()) continue;
            this.defaultBars.add(name);
        }
        this.lineValues = this.registeredBossBars.values().toArray(new BossBar[0]);
    }

    @Override
    public void load() {
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%countdown%", 100, () -> {
            long seconds = TimeUnit.MILLISECONDS.toSeconds(this.announceEndTime - System.currentTimeMillis());
            if (seconds < 0L) {
                return "0";
            }
            return Long.toString(seconds);
        });
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating display conditions";
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        if (!this.hasBossBarVisible(p)) {
            return;
        }
        boolean conditionResultChange = false;
        for (BossBar line : this.lineValues) {
            if (((BossBarLine)line).isConditionMet(p) == p.bossbarData.visibleBossBars.containsKey(line)) continue;
            conditionResultChange = true;
        }
        if (conditionResultChange) {
            for (BossBar line : this.lineValues) {
                line.removePlayer(p);
            }
            this.showBossBars(p);
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.setBossBarVisible(connectedPlayer, this.configuration.isHiddenByDefault() == this.bossBarOffPlayers.contains(connectedPlayer.getName()), false);
    }

    @Override
    public boolean onCommand(@NotNull TabPlayer sender, @NotNull String message) {
        if (message.equals(this.configuration.getToggleCommand())) {
            TAB.getInstance().getCommand().execute(sender, new String[]{"bossbar"});
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getCommand() {
        return this.configuration.getToggleCommand();
    }

    protected void detectBossBarsAndSend(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (!this.hasBossBarVisible(p)) {
            return;
        }
        this.showBossBars(p);
    }

    private void showBossBars(@NonNull TabPlayer p) {
        BossBarLine bar;
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        for (String defaultBar : this.defaultBars) {
            bar = (BossBarLine)this.registeredBossBars.get(defaultBar);
            if (!bar.isConditionMet(p) || p.bossbarData.visibleBossBars.containsKey(bar)) continue;
            bar.addPlayer(p);
        }
        for (BossBar announced : this.announcedBossBars) {
            bar = (BossBarLine)announced;
            if (!bar.isConditionMet(p) || p.bossbarData.visibleBossBars.containsKey(bar)) continue;
            bar.addPlayer(p);
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        for (BossBar line : this.lineValues) {
            ((BossBarLine)line).removePlayerRaw(disconnectedPlayer);
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "BossBar";
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NonNull String title, float progress, @NonNull BarColor color, @NonNull BarStyle style) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.ensureActive();
        return this.createBossBar(title, String.valueOf(progress), color.toString(), style.toString());
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NonNull String title, @NonNull String progress, @NonNull String color, @NonNull String style) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.ensureActive();
        UUID id = UUID.randomUUID();
        BossBarLine bar = new BossBarLine(this, id.toString(), new BossBarConfiguration.BossBarDefinition(style, color, progress, title, true, null));
        this.registeredBossBars.put(id.toString(), bar);
        this.lineValues = this.registeredBossBars.values().toArray(new BossBar[0]);
        return bar;
    }

    @Override
    public BossBar getBossBar(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.ensureActive();
        return this.registeredBossBars.get(name);
    }

    @Override
    public void toggleBossBar(@NonNull me.neznamy.tab.api.TabPlayer player, boolean sendToggleMessage) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.setBossBarVisible(player, !this.hasBossBarVisible(player), sendToggleMessage);
    }

    @Override
    public boolean hasBossBarVisible(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).bossbarData.visible;
    }

    @Override
    public void setBossBarVisible(@NonNull me.neznamy.tab.api.TabPlayer p, boolean visible, boolean sendToggleMessage) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        if (player.bossbarData.visible == visible) {
            return;
        }
        if (visible) {
            player.bossbarData.visible = true;
            this.detectBossBarsAndSend(player);
            if (sendToggleMessage) {
                player.sendMessage(this.toggleOnMessage, true);
            }
            if (this.configuration.isRememberToggleChoice()) {
                if (this.configuration.isHiddenByDefault()) {
                    if (!this.bossBarOffPlayers.contains(player.getName())) {
                        this.bossBarOffPlayers.add(player.getName());
                        this.savePlayers();
                    }
                } else if (this.bossBarOffPlayers.remove(player.getName())) {
                    this.savePlayers();
                }
            }
        } else {
            player.bossbarData.visible = false;
            for (BossBar l : this.lineValues) {
                l.removePlayer(player);
            }
            if (sendToggleMessage) {
                player.sendMessage(this.toggleOffMessage, true);
            }
            if (this.configuration.isRememberToggleChoice()) {
                if (this.configuration.isHiddenByDefault()) {
                    if (this.bossBarOffPlayers.remove(player.getName())) {
                        this.savePlayers();
                    }
                } else if (!this.bossBarOffPlayers.contains(player.getName())) {
                    this.bossBarOffPlayers.add(player.getName());
                    this.savePlayers();
                }
            }
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setBossBarVisible(player, visible);
    }

    private void savePlayers() {
        TAB.getInstance().getConfiguration().getPlayerDataFile().set("bossbar-off", new ArrayList<String>(this.bossBarOffPlayers));
    }

    @Override
    public void sendBossBarTemporarily(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull String bossBar, int duration) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (bossBar == null) {
            throw new NullPointerException("bossBar is marked non-null but is null");
        }
        this.ensureActive();
        BossBar line = this.registeredBossBars.get(bossBar);
        if (line == null) {
            throw new IllegalArgumentException("No registered BossBar found with name " + bossBar);
        }
        if (!this.hasBossBarVisible(player)) {
            return;
        }
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> line.addPlayer(player), this.getFeatureName(), "Adding temporary BossBar"));
        this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            if (((TabPlayer)player).isOnline()) {
                line.removePlayer(player);
            }
        }, this.getFeatureName(), "Removing temporary BossBar"), duration * 1000);
    }

    @Override
    public void announceBossBar(@NonNull String bossBar, int duration) {
        if (bossBar == null) {
            throw new NullPointerException("bossBar is marked non-null but is null");
        }
        this.ensureActive();
        BossBar line = this.registeredBossBars.get(bossBar);
        if (line == null) {
            throw new IllegalArgumentException("No registered BossBar found with name " + bossBar);
        }
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            List players = Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(this::hasBossBarVisible).collect(Collectors.toList());
            this.announcedBossBars.add(line);
            this.announceEndTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(duration);
            for (TabPlayer all : players) {
                if (!((BossBarLine)line).isConditionMet(all)) continue;
                line.addPlayer(all);
            }
        }, this.getFeatureName(), "Adding announced BossBar"));
        this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            List players = Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(this::hasBossBarVisible).collect(Collectors.toList());
            for (TabPlayer all : players) {
                line.removePlayer(all);
            }
            this.announcedBossBars.remove(line);
        }, this.getFeatureName(), "Removing announced BossBar"), duration * 1000);
    }

    public StringToComponentCache getCache() {
        return this.cache;
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    @Override
    public Map<String, BossBar> getRegisteredBossBars() {
        return this.registeredBossBars;
    }

    public BossBarConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public List<BossBar> getAnnouncedBossBars() {
        return this.announcedBossBars;
    }

    public static class PlayerData {
        public boolean visible;
        public final Map<BossBarLine, BossBarProperties> visibleBossBars = new IdentityHashMap<BossBarLine, BossBarProperties>();
    }

    public static class BossBarProperties {
        @NonNull
        public final Property textProperty;
        @NonNull
        public final Property progressProperty;
        @NonNull
        public final Property colorProperty;
        @NonNull
        public final Property styleProperty;

        public BossBarProperties(@NonNull Property textProperty, @NonNull Property progressProperty, @NonNull Property colorProperty, @NonNull Property styleProperty) {
            if (textProperty == null) {
                throw new NullPointerException("textProperty is marked non-null but is null");
            }
            if (progressProperty == null) {
                throw new NullPointerException("progressProperty is marked non-null but is null");
            }
            if (colorProperty == null) {
                throw new NullPointerException("colorProperty is marked non-null but is null");
            }
            if (styleProperty == null) {
                throw new NullPointerException("styleProperty is marked non-null but is null");
            }
            this.textProperty = textProperty;
            this.progressProperty = progressProperty;
            this.colorProperty = colorProperty;
            this.styleProperty = styleProperty;
        }
    }
}

