/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.globalplayerlist;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerListConfiguration;
import me.neznamy.tab.shared.features.playerlist.PlayerList;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.GameModeListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RedisFeature;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabListClearListener;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.OnlinePlayers;
import me.neznamy.tab.shared.util.PerformanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalPlayerList
extends RefreshableFeature
implements JoinListener,
QuitListener,
VanishListener,
GameModeListener,
Loadable,
UnLoadable,
ServerSwitchListener,
TabListClearListener,
CustomThreaded,
RedisFeature {
    private final ThreadExecutor customThread = new ThreadExecutor("TAB Global PlayerList Thread");
    private OnlinePlayers onlinePlayers;
    @Nullable
    private final RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
    @NotNull
    private final GlobalPlayerListConfiguration configuration;
    @NotNull
    private final Map<String, String> serverToGroupName = new HashMap<String, String>();
    @NotNull
    private final Map<String, Object> groupNameToGroup = new HashMap<String, Object>();
    @Nullable
    private final PlayerList playerlist = (PlayerList)TAB.getInstance().getFeatureManager().getFeature("PlayerList");

    public GlobalPlayerList(@NotNull GlobalPlayerListConfiguration configuration) {
        this.configuration = configuration;
        for (Map.Entry<String, List<String>> entry : configuration.getSharedServers().entrySet()) {
            TAB.getInstance().getPlaceholderManager().registerServerPlaceholder(TabConstants.Placeholder.globalPlayerListGroup(entry.getKey()), 1000, () -> {
                if (this.onlinePlayers == null) {
                    return "0";
                }
                int count = 0;
                for (TabPlayer player : this.onlinePlayers.getPlayers()) {
                    if (!((List)entry.getValue()).contains(player.server) || player.isVanished()) continue;
                    ++count;
                }
                if (this.redis != null) {
                    for (RedisPlayer player : this.redis.getRedisPlayers().values()) {
                        if (!((List)entry.getValue()).contains(player.server) || player.isVanished()) continue;
                        ++count;
                    }
                }
                return PerformanceUtil.toString(count);
            });
        }
    }

    @Override
    public void load() {
        this.onlinePlayers = new OnlinePlayers(TAB.getInstance().getOnlinePlayers());
        if (this.configuration.isUpdateLatency()) {
            this.addUsedPlaceholder("%ping%");
        }
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            all.globalPlayerListData.serverGroup = this.getServerGroup(all.server);
            all.globalPlayerListData.onSpyServer = this.configuration.getSpyServers().contains(all.server.toLowerCase());
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            for (TabPlayer displayed : this.onlinePlayers.getPlayers()) {
                if (viewer.server.equals(displayed.server) || !this.shouldSee(viewer, displayed)) continue;
                viewer.getTabList().addEntry(this.getAddInfoData(displayed, viewer));
            }
        }
    }

    public boolean shouldSee(@NotNull TabPlayer viewer, @NotNull TabPlayer displayed) {
        if (displayed == viewer) {
            return true;
        }
        if (!TAB.getInstance().getPlatform().canSee(viewer, displayed)) {
            return false;
        }
        if (viewer.globalPlayerListData.onSpyServer) {
            return true;
        }
        return viewer.globalPlayerListData.serverGroup == displayed.globalPlayerListData.serverGroup;
    }

    @NotNull
    public synchronized String getServerGroupName(@NotNull String playerServer) {
        return this.serverToGroupName.computeIfAbsent(playerServer, this::computeServerGroup);
    }

    @NotNull
    private synchronized Object getServerGroup(@NotNull String playerServer) {
        return this.groupNameToGroup.computeIfAbsent(this.getServerGroupName(playerServer), n -> new Object());
    }

    @NotNull
    private String computeServerGroup(@NotNull String server) {
        for (Map.Entry<String, List<String>> group : this.configuration.getSharedServers().entrySet()) {
            for (String serverDefinition : group.getValue()) {
                if (!(serverDefinition.endsWith("*") ? server.toLowerCase().startsWith(serverDefinition.substring(0, serverDefinition.length() - 1).toLowerCase()) : (serverDefinition.startsWith("*") ? server.toLowerCase().endsWith(serverDefinition.substring(1).toLowerCase()) : server.equalsIgnoreCase(serverDefinition)))) continue;
                return group.getKey();
            }
        }
        return this.configuration.isIsolateUnlistedServers() ? "isolated:" + server : "DEFAULT";
    }

    @Override
    public void unload() {
        for (TabPlayer displayed : this.onlinePlayers.getPlayers()) {
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                if (displayed.server.equals(viewer.server)) continue;
                viewer.getTabList().removeEntry(displayed.getTablistId());
            }
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.onlinePlayers.addPlayer(connectedPlayer);
        connectedPlayer.globalPlayerListData.serverGroup = this.getServerGroup(connectedPlayer.server);
        connectedPlayer.globalPlayerListData.onSpyServer = this.configuration.getSpyServers().contains(connectedPlayer.server.toLowerCase());
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            if (connectedPlayer.server.equals(all.server)) continue;
            if (this.shouldSee(all, connectedPlayer)) {
                all.getTabList().addEntry(this.getAddInfoData(connectedPlayer, all));
            }
            if (!this.shouldSee(connectedPlayer, all)) continue;
            connectedPlayer.getTabList().addEntry(this.getAddInfoData(all, connectedPlayer));
        }
        if (this.redis != null) {
            for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                if (redis.server.equals(connectedPlayer.server) || !this.shouldSee(connectedPlayer, redis)) continue;
                connectedPlayer.getTabList().addEntry(this.getEntry(redis));
            }
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        this.onlinePlayers.removePlayer(disconnectedPlayer);
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            all.getTabList().removeEntry(disconnectedPlayer.getTablistId());
        }
    }

    @Override
    public void onServerChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        changed.globalPlayerListData.serverGroup = this.getServerGroup(changed.server);
        changed.globalPlayerListData.onSpyServer = this.configuration.getSpyServers().contains(changed.server.toLowerCase());
        this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            for (TabPlayer all : this.onlinePlayers.getPlayers()) {
                if (all.server.equals(changed.server)) continue;
                all.getTabList().removeEntry(changed.getTablistId());
                if (!this.shouldSee(all, changed)) continue;
                all.getTabList().addEntry(this.getAddInfoData(changed, all));
            }
        }, this.getFeatureName(), "Server Switch"), 200);
    }

    @Override
    public void onTabListClear(@NotNull TabPlayer player) {
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            if (all.server.equals(player.server) || !this.shouldSee(player, all)) continue;
            player.getTabList().addEntry(this.getAddInfoData(all, player));
        }
        if (this.redis != null) {
            for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                if (redis.server.equals(player.server) || !this.shouldSee(player, redis)) continue;
                player.getTabList().addEntry(this.getEntry(redis));
            }
        }
    }

    @NotNull
    public TabList.Entry getAddInfoData(@NotNull TabPlayer p, @NotNull TabPlayer viewer) {
        TabComponent format = null;
        if (this.playerlist != null && !p.tablistData.disabled.get()) {
            format = this.playerlist.getTabFormat(p, viewer);
        }
        int gameMode = this.configuration.isOthersAsSpectators() && !p.server.equals(viewer.server) || this.configuration.isVanishedAsSpectators() && p.isVanished() ? 3 : p.getGamemode();
        return new TabList.Entry(p.getTablistId(), p.getNickname(), p.getSkin(), true, this.configuration.isUpdateLatency() ? p.getPing() : 0, gameMode, viewer.getVersion().getMinorVersion() >= 8 ? format : null, 0, true);
    }

    @Override
    public void onGameModeChange(@NotNull TabPlayer player) {
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            if (player.server.equals(viewer.server)) continue;
            viewer.getTabList().updateGameMode(player.getTablistId(), this.configuration.isOthersAsSpectators() ? 3 : player.getGamemode());
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer p) {
        if (p.isVanished()) {
            for (TabPlayer all : this.onlinePlayers.getPlayers()) {
                if (all == p || this.shouldSee(all, p)) continue;
                all.getTabList().removeEntry(p.getTablistId());
            }
        } else {
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                if (viewer == p || !this.shouldSee(viewer, p)) continue;
                viewer.getTabList().addEntry(this.getAddInfoData(p, viewer));
            }
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating latency";
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            if (viewer.globalPlayerListData.serverGroup != refreshed.globalPlayerListData.serverGroup || refreshed.server.equals(viewer.server)) continue;
            viewer.getTabList().updateLatency(refreshed.getTablistId(), refreshed.getPing());
        }
    }

    private boolean shouldSee(@NotNull TabPlayer viewer, @NotNull RedisPlayer target) {
        if (target.isVanished() && !viewer.hasPermission("tab.seevanished")) {
            return false;
        }
        if (viewer.globalPlayerListData.onSpyServer) {
            return true;
        }
        return viewer.globalPlayerListData.serverGroup == target.serverGroup;
    }

    @NotNull
    private TabList.Entry getEntry(@NotNull RedisPlayer player) {
        return new TabList.Entry(player.getUniqueId(), player.getNickname(), player.getSkin(), true, 0, 0, player.getTabFormat(), 0, true);
    }

    @Override
    public void onJoin(@NotNull RedisPlayer player) {
        player.serverGroup = this.getServerGroup(player.server);
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            if (!this.shouldSee(viewer, player) || viewer.server.equals(player.server)) continue;
            viewer.getTabList().addEntry(this.getEntry(player));
        }
    }

    @Override
    public void onServerSwitch(@NotNull RedisPlayer player) {
        player.serverGroup = this.getServerGroup(player.server);
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            if (viewer.server.equals(player.server)) continue;
            if (this.shouldSee(viewer, player)) {
                viewer.getTabList().addEntry(this.getEntry(player));
                continue;
            }
            viewer.getTabList().removeEntry(player.getUniqueId());
        }
    }

    @Override
    public void onQuit(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            if (player.server.equals(viewer.server)) continue;
            viewer.getTabList().removeEntry(player.getUniqueId());
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull RedisPlayer player) {
        if (player.isVanished()) {
            for (TabPlayer all : this.onlinePlayers.getPlayers()) {
                if (this.shouldSee(all, player)) continue;
                all.getTabList().removeEntry(player.getUniqueId());
            }
        } else {
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                if (!this.shouldSee(viewer, player)) continue;
                viewer.getTabList().addEntry(this.getEntry(player));
            }
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Global PlayerList";
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    public OnlinePlayers getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public static class PlayerData {
        private Object serverGroup;
        private boolean onSpyServer;
    }
}

