/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.header;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.neznamy.tab.api.tablist.HeaderFooterManager;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.features.header.HeaderFooterConfiguration;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.GroupListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaderFooter
extends RefreshableFeature
implements HeaderFooterManager,
JoinListener,
Loadable,
UnLoadable,
WorldSwitchListener,
ServerSwitchListener,
CustomThreaded,
GroupListener {
    private final StringToComponentCache headerCache = new StringToComponentCache("Header", 1000);
    private final StringToComponentCache footerCache = new StringToComponentCache("Footer", 1000);
    private final ThreadExecutor customThread = new ThreadExecutor("TAB Header/Footer Thread");
    private final HeaderFooterConfiguration configuration;
    private final DisableChecker disableChecker;

    public HeaderFooter(@NotNull HeaderFooterConfiguration configuration) {
        this.configuration = configuration;
        this.disableChecker = new DisableChecker(this, Condition.getCondition(configuration.getDisableCondition()), this::onDisableConditionChange, p -> p.headerFooterData.disabled);
        TAB.getInstance().getFeatureManager().registerFeature("HeaderFooter-Condition", this.disableChecker);
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.headerFooterData.disabled.get()) continue;
            this.sendHeaderFooter(p, "", "");
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        connectedPlayer.headerFooterData.header = new Property(this, connectedPlayer, this.getFromConfig(connectedPlayer, "header"));
        connectedPlayer.headerFooterData.footer = new Property(this, connectedPlayer, this.getFromConfig(connectedPlayer, "footer"));
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.headerFooterData.disabled.set(true);
        } else {
            this.sendHeaderFooter(connectedPlayer, connectedPlayer.headerFooterData.header.get(), connectedPlayer.headerFooterData.footer.get());
        }
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        this.updateProperties(p);
        this.sendHeaderFooter(p, p.headerFooterData.header.get(), p.headerFooterData.footer.get());
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        if (this.updateProperties(p)) {
            this.sendHeaderFooter(p, p.headerFooterData.header.get(), p.headerFooterData.footer.get());
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating header/footer";
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        this.sendHeaderFooter(p, p.headerFooterData.header.updateAndGet(), p.headerFooterData.footer.updateAndGet());
    }

    @Override
    public void onGroupChange(@NotNull TabPlayer player) {
        if (this.updateProperties(player)) {
            this.sendHeaderFooter(player, player.headerFooterData.header.get(), player.headerFooterData.footer.get());
        }
    }

    private boolean updateProperties(@NotNull TabPlayer player) {
        boolean changed = player.headerFooterData.header.changeRawValue(this.getFromConfig(player, "header"), null);
        if (player.headerFooterData.footer.changeRawValue(this.getFromConfig(player, "footer"), null)) {
            changed = true;
        }
        return changed;
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        if (disabledNow) {
            p.getTabList().setPlayerListHeaderFooter(new SimpleComponent(""), new SimpleComponent(""));
        } else {
            this.sendHeaderFooter(p, p.headerFooterData.header.get(), p.headerFooterData.footer.get());
        }
    }

    private String getFromConfig(TabPlayer p, String property) {
        String[] value = TAB.getInstance().getConfiguration().getUsers().getProperty(p.getName(), property, p.server, p.world);
        if (value.length > 0) {
            return value[0];
        }
        value = TAB.getInstance().getConfiguration().getUsers().getProperty(p.getUniqueId().toString(), property, p.server, p.world);
        if (value.length > 0) {
            return value[0];
        }
        value = TAB.getInstance().getConfiguration().getGroups().getProperty(p.getGroup(), property, p.server, p.world);
        if (value.length > 0) {
            return value[0];
        }
        List<String> lines = null;
        HeaderFooterConfiguration.HeaderFooterPair pair = this.configuration.getPerWorld().get(TAB.getInstance().getConfiguration().getGroup(this.configuration.getPerWorld().keySet(), p.world));
        if (pair != null) {
            List<String> list = lines = property.equals("header") ? pair.getHeader() : pair.getFooter();
        }
        if (lines == null && (pair = this.configuration.getPerServer().get(TAB.getInstance().getConfiguration().getGroup(this.configuration.getPerServer().keySet(), p.server))) != null) {
            List<String> list = lines = property.equals("header") ? pair.getHeader() : pair.getFooter();
        }
        if (lines == null) {
            lines = property.equals("header") ? this.configuration.getHeader() : this.configuration.getFooter();
        }
        return String.join((CharSequence)"\n", lines);
    }

    private void sendHeaderFooter(TabPlayer player, String header, String footer) {
        if (player.headerFooterData.disabled.get()) {
            return;
        }
        player.getTabList().setPlayerListHeaderFooter((TabComponent)this.headerCache.get(header), (TabComponent)this.footerCache.get(footer));
    }

    @Override
    public void setHeader(@NotNull me.neznamy.tab.api.TabPlayer p, @Nullable String header) {
        this.ensureActive();
        this.customThread.execute(() -> {
            TabPlayer player = (TabPlayer)p;
            player.headerFooterData.header.setTemporaryValue(header);
            this.sendHeaderFooter(player, player.headerFooterData.header.updateAndGet(), player.headerFooterData.footer.updateAndGet());
        });
    }

    @Override
    public void setFooter(@NotNull me.neznamy.tab.api.TabPlayer p, @Nullable String footer) {
        this.ensureActive();
        this.customThread.execute(() -> {
            TabPlayer player = (TabPlayer)p;
            player.headerFooterData.footer.setTemporaryValue(footer);
            this.sendHeaderFooter(player, player.headerFooterData.header.updateAndGet(), player.headerFooterData.footer.updateAndGet());
        });
    }

    @Override
    public void setHeaderAndFooter(@NotNull me.neznamy.tab.api.TabPlayer p, @Nullable String header, @Nullable String footer) {
        this.ensureActive();
        this.customThread.execute(() -> {
            TabPlayer player = (TabPlayer)p;
            player.headerFooterData.header.setTemporaryValue(header);
            player.headerFooterData.footer.setTemporaryValue(footer);
            this.sendHeaderFooter(player, player.headerFooterData.header.updateAndGet(), player.headerFooterData.footer.updateAndGet());
        });
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Header/Footer";
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    public static class PlayerData {
        public Property header;
        public Property footer;
        public final AtomicBoolean disabled = new AtomicBoolean();
    }
}

