/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.header;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaderFooterConfiguration {
    @NotNull
    private final List<String> header;
    @NotNull
    private final List<String> footer;
    @NotNull
    private final String disableCondition;
    @NotNull
    private final Map<String, HeaderFooterPair> perWorld;
    @NotNull
    private final Map<String, HeaderFooterPair> perServer;

    @NotNull
    public static HeaderFooterConfiguration fromSection(@NotNull ConfigurationSection section) {
        section.checkForUnknownKey(Arrays.asList("enabled", "header", "footer", "disable-condition", "per-world", "per-server"));
        List<String> header = section.getStringList("header", Collections.emptyList());
        List<String> footer = section.getStringList("footer", Collections.emptyList());
        return new HeaderFooterConfiguration(header, footer, section.getString("disable-condition", "%world%=disabledworld"), HeaderFooterConfiguration.getPairs(section.getConfigurationSection("per-world"), "world", header, footer), HeaderFooterConfiguration.getPairs(section.getConfigurationSection("per-server"), "server", header, footer));
    }

    @NotNull
    private static Map<String, HeaderFooterPair> getPairs(@NotNull ConfigurationSection section, @NotNull String type, @NotNull List<String> header, @NotNull List<String> footer) {
        HashMap<String, HeaderFooterPair> pairs = new HashMap<String, HeaderFooterPair>();
        for (Object key : section.getKeys()) {
            String asString = key.toString();
            HeaderFooterPair pair = HeaderFooterPair.fromSection(section.getConfigurationSection(asString));
            pairs.put(asString, pair);
            if (header.equals(pair.getHeader())) {
                section.hint("Per-" + type + " header for " + type + " \"" + key + "\" is identical to default header. This is redundant and can be removed for cleaner config.");
            }
            if (!footer.equals(pair.getFooter())) continue;
            section.hint("Per-" + type + " footer for " + type + " \"" + key + "\" is identical to default footer. This is redundant and can be removed for cleaner config.");
        }
        return pairs;
    }

    @NotNull
    public List<String> getHeader() {
        return this.header;
    }

    @NotNull
    public List<String> getFooter() {
        return this.footer;
    }

    @NotNull
    public String getDisableCondition() {
        return this.disableCondition;
    }

    @NotNull
    public Map<String, HeaderFooterPair> getPerWorld() {
        return this.perWorld;
    }

    @NotNull
    public Map<String, HeaderFooterPair> getPerServer() {
        return this.perServer;
    }

    public HeaderFooterConfiguration(@NotNull List<String> header, @NotNull List<String> footer, @NotNull String disableCondition, @NotNull Map<String, HeaderFooterPair> perWorld, @NotNull Map<String, HeaderFooterPair> perServer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        if (disableCondition == null) {
            throw new NullPointerException("disableCondition is marked non-null but is null");
        }
        if (perWorld == null) {
            throw new NullPointerException("perWorld is marked non-null but is null");
        }
        if (perServer == null) {
            throw new NullPointerException("perServer is marked non-null but is null");
        }
        this.header = header;
        this.footer = footer;
        this.disableCondition = disableCondition;
        this.perWorld = perWorld;
        this.perServer = perServer;
    }

    public static class HeaderFooterPair {
        @Nullable
        private final List<String> header;
        @Nullable
        private final List<String> footer;

        public static HeaderFooterPair fromSection(@NotNull ConfigurationSection section) {
            section.checkForUnknownKey(Arrays.asList("header", "footer"));
            return new HeaderFooterPair(section.getStringList("header"), section.getStringList("footer"));
        }

        @Nullable
        public List<String> getHeader() {
            return this.header;
        }

        @Nullable
        public List<String> getFooter() {
            return this.footer;
        }

        public HeaderFooterPair(@Nullable List<String> header, @Nullable List<String> footer) {
            this.header = header;
            this.footer = footer;
        }
    }
}

