/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.injection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.NoSuchElementException;
import java.util.function.Function;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import org.jetbrains.annotations.NotNull;

public abstract class NettyPipelineInjector
extends PipelineInjector {
    @NotNull
    private final String injectPosition;
    private final Function<TabPlayer, ChannelDuplexHandler> channelFunction = TabChannelDuplexHandler::new;

    @NotNull
    protected abstract Channel getChannel(@NotNull TabPlayer var1);

    @Override
    public void inject(@NotNull TabPlayer player) {
        Channel channel = this.getChannel(player);
        if (!channel.pipeline().names().contains(this.injectPosition)) {
            return;
        }
        this.uninject(player);
        try {
            channel.pipeline().addBefore(this.injectPosition, "TAB", (ChannelHandler)this.getChannelFunction().apply(player));
        }
        catch (IllegalArgumentException | NoSuchElementException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void uninject(@NotNull TabPlayer player) {
        Channel channel = this.getChannel(player);
        try {
            if (channel.pipeline().names().contains("TAB")) {
                channel.pipeline().remove("TAB");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public NettyPipelineInjector(@NotNull String injectPosition) {
        if (injectPosition == null) {
            throw new NullPointerException("injectPosition is marked non-null but is null");
        }
        this.injectPosition = injectPosition;
    }

    public Function<TabPlayer, ChannelDuplexHandler> getChannelFunction() {
        return this.channelFunction;
    }

    public static class TabChannelDuplexHandler
    extends ChannelDuplexHandler {
        protected final TabPlayer player;

        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) {
            try {
                if (this.player.getVersion().getMinorVersion() >= 8) {
                    ((TrackedTabList)this.player.getTabList()).onPacketSend(packet);
                }
                if (((SafeScoreboard)this.player.getScoreboard()).isAntiOverrideTeams() || ((SafeScoreboard)this.player.getScoreboard()).isAntiOverrideScoreboard()) {
                    ((SafeScoreboard)this.player.getScoreboard()).onPacketSend(packet);
                }
            }
            catch (Throwable e) {
                TAB.getInstance().getErrorManager().printError("An error occurred when reading packets", e);
            }
            try {
                super.write(context, packet, channelPromise);
            }
            catch (Throwable e) {
                TAB.getInstance().getErrorManager().printError(String.format("Failed to forward packet %s to %s", packet.getClass().getSimpleName(), this.player.getName()), e);
            }
        }

        public TabChannelDuplexHandler(TabPlayer player) {
            this.player = player;
        }
    }
}

