/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.features.layout.LayoutConfiguration;
import me.neznamy.tab.shared.features.layout.LayoutView;
import me.neznamy.tab.shared.features.layout.PlayerSlot;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentGroup {
    @NotNull
    private final LayoutView layout;
    @Nullable
    private final Condition condition;
    private final int[] slots;
    private final TabPlayer viewer;
    private final Map<Integer, PlayerSlot> playerSlots = new HashMap<Integer, PlayerSlot>();
    private final Map<TabPlayer, PlayerSlot> players = new HashMap<TabPlayer, PlayerSlot>();

    public ParentGroup(@NotNull LayoutView layout, @NotNull LayoutConfiguration.LayoutDefinition.GroupPattern pattern, @NotNull TabPlayer viewer) {
        this.layout = layout;
        this.condition = Condition.getCondition(pattern.getCondition());
        this.slots = pattern.getSlots();
        this.viewer = viewer;
        for (int slot : this.slots) {
            this.playerSlots.put(slot, new PlayerSlot(slot, layout, layout.getManager().getUUID(slot)));
        }
    }

    public void tick(@NotNull List<TabPlayer> remainingPlayers) {
        this.players.clear();
        ArrayList<TabPlayer> meetingCondition = new ArrayList<TabPlayer>();
        for (TabPlayer p : remainingPlayers) {
            if (this.condition != null && !this.condition.isMet(p)) continue;
            meetingCondition.add(p);
        }
        remainingPlayers.removeAll(meetingCondition);
        for (int index = 0; index < this.slots.length; ++index) {
            int slot = this.slots[index];
            if (this.layout.getManager().getConfiguration().isRemainingPlayersTextEnabled() && index == this.slots.length - 1 && this.playerSlots.size() < meetingCondition.size()) {
                this.playerSlots.get(slot).setText(String.format(this.layout.getManager().getConfiguration().getRemainingPlayersText(), meetingCondition.size() - this.playerSlots.size() + 1));
                break;
            }
            if (meetingCondition.size() > index) {
                TabPlayer p = (TabPlayer)meetingCondition.get(index);
                this.playerSlots.get(slot).setPlayer(p);
                this.players.put(p, this.playerSlots.get(slot));
                continue;
            }
            this.playerSlots.get(slot).setText("");
        }
    }

    public void sendSlots() {
        for (PlayerSlot s : this.playerSlots.values()) {
            this.viewer.getTabList().addEntry(s.getSlot(this.viewer));
        }
    }

    public int[] getSlots() {
        return this.slots;
    }

    public Map<Integer, PlayerSlot> getPlayerSlots() {
        return this.playerSlots;
    }

    public Map<TabPlayer, PlayerSlot> getPlayers() {
        return this.players;
    }
}

