/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.UUID;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.layout.LayoutManagerImpl;
import me.neznamy.tab.shared.features.layout.LayoutView;
import me.neznamy.tab.shared.features.playerlist.PlayerList;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSlot {
    private static final StringToComponentCache cache = new StringToComponentCache("LayoutPlayerSlot", 100);
    private final int slot;
    private final LayoutView layout;
    private final UUID uniqueId;
    private TabPlayer player;
    private String text = "";

    public void setPlayer(@Nullable TabPlayer newPlayer) {
        if (this.player == newPlayer) {
            return;
        }
        this.player = newPlayer;
        if (this.player != null) {
            this.text = "";
        }
        if (this.layout.getViewer().getVersion().getMinorVersion() < 8 || this.layout.getViewer().isBedrockPlayer()) {
            return;
        }
        this.layout.getViewer().getTabList().removeEntry(this.uniqueId);
        this.layout.getViewer().getTabList().addEntry(this.getSlot(this.layout.getViewer()));
    }

    @NotNull
    public TabList.Entry getSlot(@NotNull TabPlayer viewer) {
        TabList.Entry data;
        TabPlayer player = this.player;
        if (player != null) {
            PlayerList playerList = this.layout.getManager().getPlayerList();
            data = new TabList.Entry(this.uniqueId, this.layout.getManager().getConfiguration().getDirection().getEntryName(viewer, this.slot, LayoutManagerImpl.isTeamsEnabled()), player.getSkin(), true, this.layout.getManager().getPingSpoof() != null ? this.layout.getManager().getPingSpoof().getConfiguration().getValue() : player.getPing(), 0, playerList == null || player.tablistData.disabled.get() ? new SimpleComponent(player.getName()) : playerList.getTabFormat(player, viewer), Integer.MAX_VALUE - this.layout.getManager().getConfiguration().getDirection().translateSlot(this.slot), true);
        } else {
            data = new TabList.Entry(this.uniqueId, this.layout.getManager().getConfiguration().getDirection().getEntryName(viewer, this.slot, LayoutManagerImpl.isTeamsEnabled()), this.layout.getManager().getSkinManager().getDefaultSkin(this.slot), true, this.layout.getManager().getConfiguration().getEmptySlotPing(), 0, new SimpleComponent(this.text), Integer.MAX_VALUE - this.layout.getManager().getConfiguration().getDirection().translateSlot(this.slot), true);
        }
        return data;
    }

    public void setText(@NotNull String text) {
        if (this.text.equals(text) && this.player == null) {
            return;
        }
        this.text = text;
        if (this.player != null) {
            this.setPlayer(null);
        } else {
            if (this.layout.getViewer().getVersion().getMinorVersion() < 8 || this.layout.getViewer().isBedrockPlayer()) {
                return;
            }
            this.layout.getViewer().getTabList().updateDisplayName(this.uniqueId, (TabComponent)cache.get(text));
        }
    }

    public PlayerSlot(int slot, LayoutView layout, UUID uniqueId) {
        this.slot = slot;
        this.layout = layout;
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public TabPlayer getPlayer() {
        return this.player;
    }
}

