/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout.skin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.file.YamlConfigurationFile;
import me.neznamy.tab.shared.features.layout.skin.MineSkin;
import me.neznamy.tab.shared.features.layout.skin.PlayerSkin;
import me.neznamy.tab.shared.features.layout.skin.SignedTexture;
import me.neznamy.tab.shared.features.layout.skin.SkinSource;
import me.neznamy.tab.shared.features.layout.skin.Texture;
import me.neznamy.tab.shared.platform.TabList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinManager {
    private final List<String> invalidSkins = new ArrayList<String>();
    private TabList.Skin defaultSkin;
    private final Map<Integer, TabList.Skin> defaultSkinHashMap = new HashMap<Integer, TabList.Skin>();
    private final Map<String, SkinSource> sources = new HashMap<String, SkinSource>();

    public SkinManager(@NotNull String defaultSkin, @NotNull Map<Integer, String> defaultSkinHashMap) {
        try {
            File f = new File(TAB.getInstance().getDataFolder(), "skincache.yml");
            if (f.exists() || f.createNewFile()) {
                YamlConfigurationFile cache = new YamlConfigurationFile(null, f);
                this.sources.put("player", new PlayerSkin(cache));
                this.sources.put("mineskin", new MineSkin(cache));
                this.sources.put("texture", new Texture(cache));
                this.sources.put("signed_texture", new SignedTexture(cache));
                this.defaultSkin = this.getSkin(defaultSkin);
                for (Map.Entry<Integer, String> entry : defaultSkinHashMap.entrySet()) {
                    TabList.Skin skin = this.getSkin(entry.getValue());
                    if (skin == null) continue;
                    this.defaultSkinHashMap.put(entry.getKey(), skin);
                }
            } else {
                TAB.getInstance().getErrorManager().criticalError("Failed to load skin cache", null);
            }
        }
        catch (IOException e) {
            TAB.getInstance().getErrorManager().criticalError("Failed to load skin cache", e);
        }
    }

    @NotNull
    public TabList.Skin getDefaultSkin(int slot) {
        return this.defaultSkinHashMap.getOrDefault(slot, this.defaultSkin);
    }

    @Nullable
    public TabList.Skin getSkin(@NotNull String skin) {
        if (this.invalidSkins.contains(skin)) {
            return this.defaultSkin;
        }
        for (Map.Entry<String, SkinSource> entry : this.sources.entrySet()) {
            if (!skin.startsWith(entry.getKey() + ":")) continue;
            TabList.Skin value = entry.getValue().getSkin(skin.substring(entry.getKey().length() + 1));
            if (value == null) {
                this.invalidSkins.add(skin);
                return this.defaultSkin;
            }
            return value;
        }
        TAB.getInstance().getConfigHelper().startup().invalidLayoutSkinDefinition(skin);
        return null;
    }

    public TabList.Skin getDefaultSkin() {
        return this.defaultSkin;
    }
}

