/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import me.neznamy.tab.api.nametag.NameTagManager;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.nametags.CollisionManager;
import me.neznamy.tab.shared.features.nametags.TeamConfiguration;
import me.neznamy.tab.shared.features.nametags.VisibilityRefresher;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.GroupListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RedisFeature;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.OnlinePlayers;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameTag
extends RefreshableFeature
implements NameTagManager,
JoinListener,
QuitListener,
Loadable,
WorldSwitchListener,
ServerSwitchListener,
VanishListener,
CustomThreaded,
RedisFeature,
GroupListener {
    private final ThreadExecutor customThread = new ThreadExecutor("TAB NameTag Thread");
    private OnlinePlayers onlinePlayers;
    private final TeamConfiguration configuration;
    private final StringToComponentCache cache = new StringToComponentCache("NameTags", 1000);
    private final CollisionManager collisionManager;
    private final int teamOptions;
    private final DisableChecker disableChecker;
    @Nullable
    private final RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");

    public NameTag(@NotNull TeamConfiguration configuration) {
        this.configuration = configuration;
        this.teamOptions = configuration.isCanSeeFriendlyInvisibles() ? 2 : 0;
        this.disableChecker = new DisableChecker(this, Condition.getCondition(configuration.getDisableCondition()), this::onDisableConditionChange, p -> p.teamData.disabled);
        this.collisionManager = new CollisionManager(this);
        TAB.getInstance().getFeatureManager().registerFeature("NameTag16-Condition", this.disableChecker);
        TAB.getInstance().getFeatureManager().registerFeature("NameTagVisibility", new VisibilityRefresher(this));
        if (this.redis != null) {
            this.redis.registerMessage("teams", UpdateRedisPlayer.class, () -> new UpdateRedisPlayer());
        }
    }

    @Override
    public void load() {
        this.onlinePlayers = new OnlinePlayers(TAB.getInstance().getOnlinePlayers());
        TAB.getInstance().getFeatureManager().registerFeature("NameTagCollision", this.collisionManager);
        this.collisionManager.load();
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            ((SafeScoreboard)all.getScoreboard()).setAntiOverrideTeams(this.configuration.isAntiOverride());
            this.loadProperties(all);
            all.teamData.teamName = all.sortingData.shortTeamName;
            if (this.disableChecker.isDisableConditionMet(all)) {
                all.teamData.disabled.set(true);
                continue;
            }
            TAB.getInstance().getPlaceholderManager().getTabExpansion().setNameTagVisibility(all, true);
            if (this.redis == null) continue;
            this.redis.sendMessage(new UpdateRedisPlayer(all.getTablistId(), all.teamData.teamName, all.teamData.prefix.get(), all.teamData.suffix.get(), this.getTeamVisibility(all, all) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER));
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            for (TabPlayer target : this.onlinePlayers.getPlayers()) {
                if (target.isVanished() && !TAB.getInstance().getPlatform().canSee(viewer, target)) {
                    target.teamData.vanishedFor.add(viewer.getUniqueId());
                }
                if (target.teamData.isDisabled()) continue;
                this.registerTeam(target, viewer);
            }
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating prefix/suffix";
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        boolean refresh;
        if (refreshed.teamData.isDisabled()) {
            return;
        }
        if (force) {
            this.updateProperties(refreshed);
            refresh = true;
        } else {
            boolean prefix = refreshed.teamData.prefix.update();
            boolean suffix = refreshed.teamData.suffix.update();
            boolean bl = refresh = prefix || suffix;
        }
        if (refresh) {
            this.updatePrefixSuffix(refreshed);
        }
    }

    @Override
    public void onGroupChange(@NotNull TabPlayer player) {
        if (this.updateProperties(player) && !player.teamData.isDisabled()) {
            this.updatePrefixSuffix(player);
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.onlinePlayers.addPlayer(connectedPlayer);
        ((SafeScoreboard)connectedPlayer.getScoreboard()).setAntiOverrideTeams(this.configuration.isAntiOverride());
        this.loadProperties(connectedPlayer);
        connectedPlayer.teamData.teamName = connectedPlayer.sortingData.shortTeamName;
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            if (all == connectedPlayer) continue;
            if (connectedPlayer.isVanished() && !TAB.getInstance().getPlatform().canSee(all, connectedPlayer)) {
                connectedPlayer.teamData.vanishedFor.add(all.getUniqueId());
            }
            if (all.isVanished() && !TAB.getInstance().getPlatform().canSee(connectedPlayer, all)) {
                all.teamData.vanishedFor.add(connectedPlayer.getUniqueId());
            }
            if (all.teamData.isDisabled()) continue;
            this.registerTeam(all, connectedPlayer);
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setNameTagVisibility(connectedPlayer, true);
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.teamData.disabled.set(true);
            return;
        }
        this.registerTeam(connectedPlayer);
        if (this.redis != null) {
            for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                if (redis.getTagPrefix() == null) continue;
                TabComponent prefix = (TabComponent)this.cache.get(redis.getTagPrefix());
                connectedPlayer.getScoreboard().registerTeam(redis.getTeamName(), prefix, (TabComponent)this.cache.get(redis.getTagSuffix()), redis.getNameVisibility(), Scoreboard.CollisionRule.ALWAYS, Collections.singletonList(redis.getNickname()), 2, prefix.getLastColor().getLegacyColor());
            }
            this.redis.sendMessage(new UpdateRedisPlayer(connectedPlayer.getTablistId(), connectedPlayer.teamData.teamName, connectedPlayer.teamData.prefix.get(), connectedPlayer.teamData.suffix.get(), this.getTeamVisibility(connectedPlayer, connectedPlayer) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER));
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        this.onlinePlayers.removePlayer(disconnectedPlayer);
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            ((SafeScoreboard)viewer.getScoreboard()).unregisterTeamSafe(disconnectedPlayer.teamData.teamName);
        }
    }

    @Override
    public void onServerChange(@NonNull TabPlayer p, @NonNull String from, @NonNull String to) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (this.updateProperties(p) && !p.teamData.isDisabled()) {
            this.updatePrefixSuffix(p);
        }
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        if (this.updateProperties(changed) && !changed.teamData.isDisabled()) {
            this.updatePrefixSuffix(changed);
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        block3: {
            block2: {
                if (!player.isVanished()) break block2;
                for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                    if (viewer == player || TAB.getInstance().getPlatform().canSee(viewer, player)) continue;
                    player.teamData.vanishedFor.add(viewer.getUniqueId());
                    if (player.teamData.isDisabled()) continue;
                    ((SafeScoreboard)viewer.getScoreboard()).unregisterTeamSafe(player.teamData.teamName);
                }
                break block3;
            }
            HashSet<UUID> ids = new HashSet<UUID>(player.teamData.vanishedFor);
            player.teamData.vanishedFor.clear();
            if (player.teamData.isDisabled()) break block3;
            for (UUID id : ids) {
                TabPlayer viewer = TAB.getInstance().getPlayer(id);
                if (viewer == null) continue;
                this.registerTeam(player, viewer);
            }
        }
    }

    private void loadProperties(@NotNull TabPlayer player) {
        player.teamData.prefix = player.loadPropertyFromConfig(this, "tagprefix", "");
        player.teamData.suffix = player.loadPropertyFromConfig(this, "tagsuffix", "");
    }

    private boolean updateProperties(@NotNull TabPlayer p) {
        boolean changed = p.updatePropertyFromConfig(p.teamData.prefix, "");
        if (p.updatePropertyFromConfig(p.teamData.suffix, "")) {
            changed = true;
        }
        return changed;
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        if (disabledNow) {
            this.unregisterTeam(p.teamData.teamName);
        } else {
            this.registerTeam(p);
        }
    }

    private void updatePrefixSuffix(@NonNull TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            TabComponent prefix = (TabComponent)this.cache.get(player.teamData.prefix.getFormat(viewer));
            viewer.getScoreboard().updateTeam(player.teamData.teamName, prefix, (TabComponent)this.cache.get(player.teamData.suffix.getFormat(viewer)), prefix.getLastColor().getLegacyColor());
        }
        if (this.redis != null) {
            this.redis.sendMessage(new UpdateRedisPlayer(player.getTablistId(), player.teamData.teamName, player.teamData.prefix.get(), player.teamData.suffix.get(), this.getTeamVisibility(player, player) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER));
        }
    }

    public void updateCollision(@NonNull TabPlayer player, boolean moveToThread) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Runnable r = () -> {
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                viewer.getScoreboard().updateTeam(player.teamData.teamName, player.teamData.getCollisionRule() ? Scoreboard.CollisionRule.ALWAYS : Scoreboard.CollisionRule.NEVER);
            }
        };
        if (moveToThread) {
            this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), r, this.getFeatureName(), "Updating collision"));
        } else {
            r.run();
        }
    }

    public void updateVisibility(@NonNull TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                viewer.getScoreboard().updateTeam(player.teamData.teamName, this.getTeamVisibility(player, viewer) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER);
            }
            if (this.redis != null) {
                this.redis.sendMessage(new UpdateRedisPlayer(player.getTablistId(), player.teamData.teamName, player.teamData.prefix.get(), player.teamData.suffix.get(), this.getTeamVisibility(player, player) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER));
            }
        }, this.getFeatureName(), "Updating visibility"));
    }

    public void updateVisibility(@NonNull TabPlayer player, @NonNull TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        viewer.getScoreboard().updateTeam(player.teamData.teamName, this.getTeamVisibility(player, viewer) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER);
    }

    private void unregisterTeam(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            ((SafeScoreboard)viewer.getScoreboard()).unregisterTeamSafe(teamName);
        }
    }

    private void registerTeam(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            this.registerTeam(p, viewer);
        }
    }

    private void registerTeam(@NonNull TabPlayer p, @NonNull TabPlayer viewer) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (p.teamData.isDisabled() || p.teamData.vanishedFor.contains(viewer.getUniqueId())) {
            return;
        }
        if (!TAB.getInstance().getPlatform().canSee(viewer, p) && p != viewer) {
            return;
        }
        TabComponent prefix = (TabComponent)this.cache.get(p.teamData.prefix.getFormat(viewer));
        viewer.getScoreboard().registerTeam(p.teamData.teamName, prefix, (TabComponent)this.cache.get(p.teamData.suffix.getFormat(viewer)), this.getTeamVisibility(p, viewer) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER, p.teamData.getCollisionRule() ? Scoreboard.CollisionRule.ALWAYS : Scoreboard.CollisionRule.NEVER, Collections.singletonList(p.getNickname()), this.teamOptions, prefix.getLastColor().getLegacyColor());
    }

    public boolean getTeamVisibility(@NonNull TabPlayer p, @NonNull TabPlayer viewer) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (viewer.getVersion().getMinorVersion() == 8 && p.hasInvisibilityPotion()) {
            return false;
        }
        return !this.hasHiddenNameTag(p) && !this.hasHiddenNameTag(p, viewer) && !this.configuration.isInvisibleNameTags() && !viewer.teamData.invisibleNameTagView;
    }

    public void updateTeamName(@NonNull TabPlayer player, @NonNull String newTeamName) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (newTeamName == null) {
            throw new NullPointerException("newTeamName is marked non-null but is null");
        }
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            if (player.teamData.teamName == null) {
                return;
            }
            if (player.teamData.isDisabled()) {
                player.teamData.teamName = newTeamName;
                return;
            }
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                viewer.getScoreboard().renameTeam(player.teamData.teamName, newTeamName);
            }
            player.teamData.teamName = newTeamName;
            if (this.redis != null) {
                this.redis.sendMessage(new UpdateRedisPlayer(player.getTablistId(), player.teamData.teamName, player.teamData.prefix.get(), player.teamData.suffix.get(), this.getTeamVisibility(player, player) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER));
            }
        }, this.getFeatureName(), "Updating team name"));
    }

    @Override
    public void onRedisLoadRequest() {
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            this.redis.sendMessage(new UpdateRedisPlayer(all.getTablistId(), all.teamData.teamName, all.teamData.prefix.get(), all.teamData.suffix.get(), this.getTeamVisibility(all, all) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER));
        }
    }

    @Override
    public void onQuit(@NotNull RedisPlayer player) {
        if (player.getTeamName() == null) {
            TAB.getInstance().getErrorManager().printError("Unable to unregister team of redis player " + player.getName() + " on quit, because team is null", null);
            return;
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            ((SafeScoreboard)viewer.getScoreboard()).unregisterTeamSafe(player.getTeamName());
        }
    }

    @Override
    public void hideNameTag(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (!p.teamData.hiddenNameTag) {
                p.teamData.hiddenNameTag = true;
                this.updateVisibility(p);
            }
        }, this.getFeatureName(), "Processing API call (hideNameTag)"));
    }

    @Override
    public void hideNameTag(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull me.neznamy.tab.api.TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (!p.teamData.addHiddenNameTagFor((TabPlayer)viewer)) {
                return;
            }
            this.updateVisibility(p, (TabPlayer)viewer);
        }, this.getFeatureName(), "Processing API call (hideNameTag)"));
    }

    @Override
    public void showNameTag(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (p.teamData.hiddenNameTag) {
                p.teamData.hiddenNameTag = false;
                this.updateVisibility(p);
            }
        }, this.getFeatureName(), "Processing API call (showNameTag)"));
    }

    @Override
    public void showNameTag(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull me.neznamy.tab.api.TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (!p.teamData.removeHiddenNameTagFor((TabPlayer)viewer)) {
                return;
            }
            this.updateVisibility(p, (TabPlayer)viewer);
        }, this.getFeatureName(), "Processing API call (showNameTag)"));
    }

    @Override
    public boolean hasHiddenNameTag(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.hiddenNameTag;
    }

    @Override
    public boolean hasHiddenNameTag(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull me.neznamy.tab.api.TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.hasHiddenNameTagFor((TabPlayer)viewer);
    }

    @Override
    public void pauseTeamHandling(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (p.teamData.teamHandlingPaused) {
                return;
            }
            if (!p.teamData.isDisabled()) {
                this.unregisterTeam(p.teamData.teamName);
            }
            p.teamData.teamHandlingPaused = true;
        }, this.getFeatureName(), "Processing API call (pauseTeamHandling)"));
    }

    @Override
    public void resumeTeamHandling(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (!p.teamData.teamHandlingPaused) {
                return;
            }
            p.teamData.teamHandlingPaused = false;
            if (!p.teamData.isDisabled()) {
                this.registerTeam(p);
            }
        }, this.getFeatureName(), "Processing API call (resumeTeamHandling)"));
    }

    @Override
    public boolean hasTeamHandlingPaused(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return ((TabPlayer)player).teamData.teamHandlingPaused;
    }

    @Override
    public void setCollisionRule(@NonNull me.neznamy.tab.api.TabPlayer player, Boolean collision) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            if (Objects.equals(p.teamData.forcedCollision, collision)) {
                return;
            }
            p.teamData.forcedCollision = collision;
            this.updateCollision(p, true);
        }, this.getFeatureName(), "Processing API call (setCollisionRule)"));
    }

    @Override
    public Boolean getCollisionRule(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.teamData.forcedCollision;
    }

    @Override
    public void setPrefix(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String prefix) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            p.teamData.prefix.setTemporaryValue(prefix);
            this.updatePrefixSuffix(p);
        }, this.getFeatureName(), "Processing API call (setPrefix)"));
    }

    @Override
    public void setSuffix(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String suffix) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            TabPlayer p = (TabPlayer)player;
            p.ensureLoaded();
            p.teamData.suffix.setTemporaryValue(suffix);
            this.updatePrefixSuffix(p);
        }, this.getFeatureName(), "Processing API call (setSuffix)"));
    }

    @Override
    public String getCustomPrefix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.teamData.prefix.getTemporaryValue();
    }

    @Override
    public String getCustomSuffix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.teamData.suffix.getTemporaryValue();
    }

    @Override
    @NotNull
    public String getOriginalPrefix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.teamData.prefix.getOriginalRawValue();
    }

    @Override
    @NotNull
    public String getOriginalSuffix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.teamData.suffix.getOriginalRawValue();
    }

    @Override
    public void toggleNameTagVisibilityView(@NonNull me.neznamy.tab.api.TabPlayer p, boolean sendToggleMessage) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        if (player.teamData.invisibleNameTagView) {
            player.teamData.invisibleNameTagView = false;
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNameTagsShown(), true);
            }
        } else {
            player.teamData.invisibleNameTagView = true;
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNameTagsHidden(), true);
            }
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setNameTagVisibility(player, !player.teamData.invisibleNameTagView);
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            this.updateVisibility(all, player);
        }
    }

    @Override
    public boolean hasHiddenNameTagVisibilityView(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.invisibleNameTagView;
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "NameTags";
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    public OnlinePlayers getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public TeamConfiguration getConfiguration() {
        return this.configuration;
    }

    public StringToComponentCache getCache() {
        return this.cache;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    public int getTeamOptions() {
        return this.teamOptions;
    }

    public DisableChecker getDisableChecker() {
        return this.disableChecker;
    }

    @Nullable
    public RedisSupport getRedis() {
        return this.redis;
    }

    private class UpdateRedisPlayer
    extends RedisMessage {
        private UUID playerId;
        private String teamName;
        private String prefix;
        private String suffix;
        private Scoreboard.NameVisibility nameVisibility;

        @Override
        @NotNull
        public ThreadExecutor getCustomThread() {
            return NameTag.this.customThread;
        }

        @Override
        public void write(@NotNull ByteArrayDataOutput out) {
            this.writeUUID(out, this.playerId);
            out.writeUTF(this.teamName);
            out.writeUTF(this.prefix);
            out.writeUTF(this.suffix);
            out.writeUTF(this.nameVisibility.toString());
        }

        @Override
        public void read(@NotNull ByteArrayDataInput in) {
            this.playerId = this.readUUID(in);
            this.teamName = in.readUTF();
            this.prefix = in.readUTF();
            this.suffix = in.readUTF();
            this.nameVisibility = Scoreboard.NameVisibility.getByName(in.readUTF());
        }

        @Override
        public void process(@NotNull RedisSupport redisSupport) {
            RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
            if (target == null) {
                TAB.getInstance().getErrorManager().printError("Unable to process nametag update of redis player " + this.playerId + ", because no such player exists", null);
                return;
            }
            if (target.getTeamName() == null) {
                TAB.getInstance().debug("Processing nametag join of redis player " + target.getName());
            }
            String oldTeamName = target.getTeamName();
            String newTeamName = this.checkTeamName(target, this.teamName.substring(0, this.teamName.length() - 1));
            target.setTeamName(newTeamName);
            target.setTagPrefix(this.prefix);
            target.setTagSuffix(this.suffix);
            target.setNameVisibility(this.nameVisibility);
            TabComponent prefixComponent = (TabComponent)NameTag.this.cache.get(this.prefix);
            if (!newTeamName.equals(oldTeamName)) {
                for (TabPlayer viewer : NameTag.this.onlinePlayers.getPlayers()) {
                    if (oldTeamName != null) {
                        viewer.getScoreboard().unregisterTeam(oldTeamName);
                    }
                    viewer.getScoreboard().registerTeam(newTeamName, prefixComponent, (TabComponent)NameTag.this.cache.get(this.suffix), this.nameVisibility, Scoreboard.CollisionRule.ALWAYS, Collections.singletonList(target.getNickname()), 2, prefixComponent.getLastColor().getLegacyColor());
                }
            } else {
                for (TabPlayer viewer : NameTag.this.onlinePlayers.getPlayers()) {
                    viewer.getScoreboard().updateTeam(oldTeamName, prefixComponent, (TabComponent)NameTag.this.cache.get(this.suffix), this.nameVisibility, Scoreboard.CollisionRule.ALWAYS, 2, prefixComponent.getLastColor().getLegacyColor());
                }
            }
        }

        @NotNull
        private String checkTeamName(@NotNull RedisPlayer player, @NotNull String currentName15) {
            char id = 'A';
            while (true) {
                String potentialTeamName = currentName15 + id;
                boolean nameTaken = false;
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    if (!potentialTeamName.equals(all.sortingData.shortTeamName)) continue;
                    nameTaken = true;
                    break;
                }
                if (!nameTaken && NameTag.this.redis != null) {
                    for (RedisPlayer all : NameTag.this.redis.getRedisPlayers().values()) {
                        if (all == player || !potentialTeamName.equals(all.getTeamName())) continue;
                        nameTaken = true;
                        break;
                    }
                }
                if (!nameTaken) {
                    return potentialTeamName;
                }
                id = (char)(id + '\u0001');
            }
        }

        public UpdateRedisPlayer() {
        }

        public UpdateRedisPlayer(UUID playerId, String teamName, String prefix, String suffix, Scoreboard.NameVisibility nameVisibility) {
            this.playerId = playerId;
            this.teamName = teamName;
            this.prefix = prefix;
            this.suffix = suffix;
            this.nameVisibility = nameVisibility;
        }
    }

    public static class PlayerData {
        public String teamName;
        public Property prefix;
        public Property suffix;
        public final AtomicBoolean disabled = new AtomicBoolean();
        public boolean hiddenNameTag;
        @Nullable
        private Set<TabPlayer> hiddenNameTagFor;
        public boolean teamHandlingPaused;
        public boolean invisibleNameTagView;
        public final Set<UUID> vanishedFor = new HashSet<UUID>();
        public boolean collisionRule;
        @Nullable
        public Boolean forcedCollision;

        public boolean getCollisionRule() {
            return this.forcedCollision != null ? this.forcedCollision : this.collisionRule;
        }

        public boolean hasHiddenNameTagFor(@NotNull TabPlayer viewer) {
            if (this.hiddenNameTagFor == null) {
                return false;
            }
            return this.hiddenNameTagFor.contains(viewer);
        }

        public boolean addHiddenNameTagFor(@NotNull TabPlayer viewer) {
            if (this.hiddenNameTagFor == null) {
                this.hiddenNameTagFor = Collections.newSetFromMap(new WeakHashMap());
            }
            return this.hiddenNameTagFor.add(viewer);
        }

        public boolean removeHiddenNameTagFor(@NotNull TabPlayer viewer) {
            if (this.hiddenNameTagFor != null) {
                return this.hiddenNameTagFor.remove(viewer);
            }
            return false;
        }

        public boolean isDisabled() {
            return this.disabled.get() || this.teamHandlingPaused;
        }
    }
}

