/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import java.util.Arrays;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class TeamConfiguration {
    @NotNull
    private final String enableCollision;
    private final boolean invisibleNameTags;
    private final boolean antiOverride;
    private final boolean canSeeFriendlyInvisibles;
    @NotNull
    private final String disableCondition;

    @NotNull
    public static TeamConfiguration fromSection(@NotNull ConfigurationSection section) {
        section.checkForUnknownKey(Arrays.asList("enabled", "enable-collision", "invisible-nametags", "anti-override", "sorting-types", "case-sensitive-sorting", "can-see-friendly-invisibles", "disable-condition"));
        boolean antiOverride = section.getBoolean("anti-override", true);
        if (!antiOverride) {
            section.startupWarn("anti-override for scoreboard-teams is disabled in config. This is usually a mistake. If you notice the feature randomly breaking, enable it back.");
        }
        return new TeamConfiguration(section.getObject("enable-collision", "true").toString(), section.getBoolean("invisible-nametags", false), antiOverride, section.getBoolean("can-see-friendly-invisibles", false), section.getString("disable-condition", "%world%=disabledworld"));
    }

    @NotNull
    public String getEnableCollision() {
        return this.enableCollision;
    }

    public boolean isInvisibleNameTags() {
        return this.invisibleNameTags;
    }

    public boolean isAntiOverride() {
        return this.antiOverride;
    }

    public boolean isCanSeeFriendlyInvisibles() {
        return this.canSeeFriendlyInvisibles;
    }

    @NotNull
    public String getDisableCondition() {
        return this.disableCondition;
    }

    public TeamConfiguration(@NotNull String enableCollision, boolean invisibleNameTags, boolean antiOverride, boolean canSeeFriendlyInvisibles, @NotNull String disableCondition) {
        if (enableCollision == null) {
            throw new NullPointerException("enableCollision is marked non-null but is null");
        }
        if (disableCondition == null) {
            throw new NullPointerException("disableCondition is marked non-null but is null");
        }
        this.enableCollision = enableCollision;
        this.invisibleNameTags = invisibleNameTags;
        this.antiOverride = antiOverride;
        this.canSeeFriendlyInvisibles = canSeeFriendlyInvisibles;
        this.disableCondition = disableCondition;
    }
}

