/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class VisibilityRefresher
extends RefreshableFeature
implements CustomThreaded {
    @NotNull
    private final NameTag nameTags;

    public VisibilityRefresher(@NotNull NameTag nameTags) {
        this.nameTags = nameTags;
        int refresh = TAB.getInstance().getPlatform().isProxy() ? -1 : 500;
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%invisible%", refresh, p -> Boolean.toString(((TabPlayer)p).hasInvisibilityPotion()));
        this.addUsedPlaceholder("%invisible%");
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating NameTag visibility";
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        if (p.teamData.isDisabled()) {
            return;
        }
        for (TabPlayer viewer : this.nameTags.getOnlinePlayers().getPlayers()) {
            if (viewer.getVersion().getMinorVersion() != 8) continue;
            this.nameTags.updateVisibility(p, viewer);
        }
    }

    @Override
    @NotNull
    public ThreadExecutor getCustomThread() {
        return this.nameTags.getCustomThread();
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.nameTags.getFeatureName();
    }
}

