/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.playerlist;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import me.neznamy.tab.api.tablist.TabListFormatManager;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.layout.PlayerSlot;
import me.neznamy.tab.shared.features.playerlist.TablistFormattingConfiguration;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.GroupListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.RedisFeature;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerList
extends RefreshableFeature
implements TabListFormatManager,
JoinListener,
Loadable,
UnLoadable,
WorldSwitchListener,
ServerSwitchListener,
VanishListener,
RedisFeature,
GroupListener {
    @NotNull
    private final StringToComponentCache cache = new StringToComponentCache("Tablist name formatting", 1000);
    @NotNull
    private final TablistFormattingConfiguration configuration;
    @Nullable
    private final RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
    @NotNull
    private final DisableChecker disableChecker;

    public PlayerList(@NotNull TablistFormattingConfiguration configuration) {
        this.configuration = configuration;
        this.disableChecker = new DisableChecker(this, Condition.getCondition(configuration.getDisableCondition()), this::onDisableConditionChange, p -> p.tablistData.disabled);
        TAB.getInstance().getFeatureManager().registerFeature("PlayerList-Condition", this.disableChecker);
        if (configuration.isAntiOverride()) {
            TAB.getInstance().getCpu().getTablistEntryCheckThread().repeatTask(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
                for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                    ((TrackedTabList)p.getTabList()).checkDisplayNames();
                }
            }, this.getFeatureName(), "Tablist anti override (periodic task)"), 500);
        }
        if (this.redis != null) {
            this.redis.registerMessage("tabformat", UpdateRedisPlayer.class, () -> new UpdateRedisPlayer());
        }
    }

    @NotNull
    public UUID getTablistUUID(@NotNull TabPlayer p, @NotNull TabPlayer viewer) {
        PlayerSlot slot;
        if (viewer.layoutData.currentLayout != null && (slot = viewer.layoutData.currentLayout.view.getSlot(p)) != null) {
            return slot.getUniqueId();
        }
        return p.getTablistId();
    }

    public void loadProperties(@NotNull TabPlayer player) {
        player.tablistData.prefix = player.loadPropertyFromConfig(this, "tabprefix", "");
        player.tablistData.name = player.loadPropertyFromConfig(this, "customtabname", player.getName());
        player.tablistData.suffix = player.loadPropertyFromConfig(this, "tabsuffix", "");
    }

    public boolean updateProperties(@NotNull TabPlayer p) {
        boolean changed = p.updatePropertyFromConfig(p.tablistData.prefix, "");
        if (p.updatePropertyFromConfig(p.tablistData.name, p.getName())) {
            changed = true;
        }
        if (p.updatePropertyFromConfig(p.tablistData.suffix, "")) {
            changed = true;
        }
        return changed;
    }

    public void updatePlayer(@NotNull TabPlayer player, boolean format) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            UUID tablistId = this.getTablistUUID(player, viewer);
            viewer.getTabList().updateDisplayName(tablistId, format ? this.getTabFormat(player, viewer) : (tablistId.getMostSignificantBits() == 0L ? new SimpleComponent(player.getName()) : null));
        }
        if (this.redis != null) {
            this.redis.sendMessage(new UpdateRedisPlayer(player.getUniqueId(), player.tablistData.prefix.get() + player.tablistData.name.get() + player.tablistData.suffix.get()));
        }
    }

    @Nullable
    public TabComponent getTabFormat(@NotNull TabPlayer p, @NotNull TabPlayer viewer) {
        Property prefix = p.tablistData.prefix;
        Property name = p.tablistData.name;
        Property suffix = p.tablistData.suffix;
        if (prefix == null || name == null || suffix == null) {
            return null;
        }
        return (TabComponent)this.cache.get(prefix.getFormat(viewer) + name.getFormat(viewer) + suffix.getFormat(viewer));
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            ((TrackedTabList)all.getTabList()).setAntiOverride(this.configuration.isAntiOverride());
            this.loadProperties(all);
            if (this.disableChecker.isDisableConditionMet(all)) {
                all.tablistData.disabled.set(true);
                continue;
            }
            if (this.redis == null) continue;
            this.redis.sendMessage(new UpdateRedisPlayer(all.getUniqueId(), all.tablistData.prefix.get() + all.tablistData.name.get() + all.tablistData.suffix.get()));
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                if (target.tablistData.disabled.get()) continue;
                viewer.getTabList().updateDisplayName(this.getTablistUUID(target, viewer), this.getTabFormat(target, viewer));
            }
        }
    }

    @Override
    public void unload() {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                if (target.tablistData.disabled.get()) continue;
                viewer.getTabList().updateDisplayName(this.getTablistUUID(target, target), null);
            }
        }
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        if (this.updateProperties(p) && !p.tablistData.disabled.get()) {
            this.updatePlayer(p, true);
        }
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("injection")) {
            return;
        }
        TAB.getInstance().getCpu().getProcessingThread().executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!all.tablistData.disabled.get() && p.getVersion().getMinorVersion() >= 8) {
                    p.getTabList().updateDisplayName(this.getTablistUUID(all, p), this.getTabFormat(all, p));
                }
                if (all == p || p.tablistData.disabled.get() || all.getVersion().getMinorVersion() < 8) continue;
                all.getTabList().updateDisplayName(this.getTablistUUID(p, all), this.getTabFormat(p, all));
            }
            if (this.redis != null) {
                for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                    p.getTabList().updateDisplayName(redis.getUniqueId(), redis.getTabFormat());
                }
            }
        }, this.getFeatureName(), "Player Join"), 300);
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        if (this.updateProperties(changed) && !changed.tablistData.disabled.get()) {
            this.updatePlayer(changed, true);
        }
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        this.updatePlayer(p, !disabledNow);
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating TabList format";
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        boolean refresh;
        if (refreshed.tablistData.prefix == null) {
            return;
        }
        if (force) {
            this.updateProperties(refreshed);
            refresh = true;
        } else {
            boolean prefix = refreshed.tablistData.prefix.update();
            boolean name = refreshed.tablistData.name.update();
            boolean suffix = refreshed.tablistData.suffix.update();
            boolean bl = refresh = prefix || name || suffix;
        }
        if (refreshed.tablistData.disabled.get()) {
            return;
        }
        if (refresh) {
            this.updatePlayer(refreshed, true);
        }
    }

    @Override
    public void onGroupChange(@NotNull TabPlayer player) {
        if (this.updateProperties(player)) {
            this.updatePlayer(player, true);
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        ((TrackedTabList)connectedPlayer.getTabList()).setAntiOverride(this.configuration.isAntiOverride());
        this.loadProperties(connectedPlayer);
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.tablistData.disabled.set(true);
        } else {
            this.updatePlayer(connectedPlayer, true);
        }
        if (connectedPlayer.getVersion().getMinorVersion() < 8) {
            return;
        }
        Runnable r = () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all == connectedPlayer) continue;
                connectedPlayer.getTabList().updateDisplayName(this.getTablistUUID(all, connectedPlayer), this.getTabFormat(all, connectedPlayer));
            }
            if (this.redis != null) {
                for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                    connectedPlayer.getTabList().updateDisplayName(redis.getUniqueId(), redis.getTabFormat());
                }
            }
        };
        if (!this.configuration.isAntiOverride() || !TAB.getInstance().getFeatureManager().isFeatureEnabled("injection")) {
            TAB.getInstance().getCpu().getProcessingThread().executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), r, this.getFeatureName(), "Player Join"), 300);
        } else {
            r.run();
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        if (player.isVanished() || player.tablistData.disabled.get()) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            viewer.getTabList().updateDisplayName(player.getTablistId(), this.getTabFormat(player, viewer));
        }
    }

    @Override
    public void setPrefix(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String prefix) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        ((TabPlayer)player).tablistData.prefix.setTemporaryValue(prefix);
        this.updatePlayer((TabPlayer)player, true);
    }

    @Override
    public void setName(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String customName) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        ((TabPlayer)player).tablistData.name.setTemporaryValue(customName);
        this.updatePlayer((TabPlayer)player, true);
    }

    @Override
    public void setSuffix(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String suffix) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        ((TabPlayer)player).tablistData.suffix.setTemporaryValue(suffix);
        this.updatePlayer((TabPlayer)player, true);
    }

    @Override
    public String getCustomPrefix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        return ((TabPlayer)player).tablistData.prefix.getTemporaryValue();
    }

    @Override
    public String getCustomName(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        return ((TabPlayer)player).tablistData.name.getTemporaryValue();
    }

    @Override
    public String getCustomSuffix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        return ((TabPlayer)player).tablistData.suffix.getTemporaryValue();
    }

    @Override
    @NotNull
    public String getOriginalPrefix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        return ((TabPlayer)player).tablistData.prefix.getOriginalRawValue();
    }

    @Override
    @NotNull
    public String getOriginalName(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        return ((TabPlayer)player).tablistData.name.getOriginalRawValue();
    }

    @Override
    @NotNull
    public String getOriginalSuffix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        ((TabPlayer)player).ensureLoaded();
        return ((TabPlayer)player).tablistData.suffix.getOriginalRawValue();
    }

    @Override
    public void onRedisLoadRequest() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.redis.sendMessage(new UpdateRedisPlayer(all.getTablistId(), all.tablistData.prefix.get() + all.tablistData.name.get() + all.tablistData.suffix.get()));
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull RedisPlayer player) {
        if (player.isVanished()) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            viewer.getTabList().updateDisplayName(player.getUniqueId(), player.getTabFormat());
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Tablist name formatting";
    }

    @NotNull
    public StringToComponentCache getCache() {
        return this.cache;
    }

    @NotNull
    public TablistFormattingConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public RedisSupport getRedis() {
        return this.redis;
    }

    @NotNull
    public DisableChecker getDisableChecker() {
        return this.disableChecker;
    }

    private class UpdateRedisPlayer
    extends RedisMessage {
        private UUID playerId;
        private String format;

        @Override
        public void write(@NotNull ByteArrayDataOutput out) {
            this.writeUUID(out, this.playerId);
            out.writeUTF(this.format);
        }

        @Override
        public void read(@NotNull ByteArrayDataInput in) {
            this.playerId = this.readUUID(in);
            this.format = in.readUTF();
        }

        @Override
        public void process(@NotNull RedisSupport redisSupport) {
            RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
            if (target == null) {
                TAB.getInstance().getErrorManager().printError("Unable to process tablist format update of redis player " + this.playerId + ", because no such player exists", null);
                return;
            }
            if (target.getTabFormat() == null) {
                TAB.getInstance().debug("Processing tablist formatting join of redis player " + target.getName());
            }
            target.setTabFormat((TabComponent)PlayerList.this.cache.get(this.format));
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer.getVersion().getMinorVersion() < 8) continue;
                viewer.getTabList().updateDisplayName(target.getUniqueId(), target.getTabFormat());
            }
        }

        public UpdateRedisPlayer() {
        }

        public UpdateRedisPlayer(UUID playerId, String format) {
            this.playerId = playerId;
            this.format = format;
        }
    }

    public static class PlayerData {
        public Property prefix;
        public Property name;
        public Property suffix;
        public final AtomicBoolean disabled = new AtomicBoolean();
    }
}

