/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.playerlist;

import java.util.Arrays;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class TablistFormattingConfiguration {
    private final boolean antiOverride;
    @NotNull
    private final String disableCondition;

    @NotNull
    public static TablistFormattingConfiguration fromSection(@NotNull ConfigurationSection section) {
        section.checkForUnknownKey(Arrays.asList("enabled", "anti-override", "disable-condition"));
        boolean antiOverride = section.getBoolean("anti-override", true);
        if (!antiOverride) {
            TAB.getInstance().getConfigHelper().startup().startupWarn("anti-override for tablist-name-formatting is disabled in config. This is usually a mistake. If you notice the feature randomly breaking, enable it back.");
        }
        return new TablistFormattingConfiguration(antiOverride, section.getString("disable-condition", "%world%=disabledworld"));
    }

    public boolean isAntiOverride() {
        return this.antiOverride;
    }

    @NotNull
    public String getDisableCondition() {
        return this.disableCondition;
    }

    public TablistFormattingConfiguration(boolean antiOverride, @NotNull String disableCondition) {
        if (disableCondition == null) {
            throw new NullPointerException("disableCondition is marked non-null but is null");
        }
        this.antiOverride = antiOverride;
        this.disableCondition = disableCondition;
    }
}

