/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.playerlistobjective;

import java.util.Arrays;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import me.neznamy.tab.shared.platform.Scoreboard;
import org.jetbrains.annotations.NotNull;

public class PlayerListObjectiveConfiguration {
    @NotNull
    private final String value;
    @NotNull
    private final String fancyValue;
    @NotNull
    private final String disableCondition;
    @NotNull
    private final Scoreboard.HealthDisplay healthDisplay;

    @NotNull
    public static PlayerListObjectiveConfiguration fromSection(@NotNull ConfigurationSection section) {
        section.checkForUnknownKey(Arrays.asList("enabled", "value", "fancy-value", "disable-condition"));
        String value = section.getString("value", "%ping%");
        if (value.isEmpty()) {
            section.startupWarn("Playerlist objective value is set to be empty, but the configured value must evaluate to a number. Using 0.");
            value = "0";
        }
        return new PlayerListObjectiveConfiguration(value, section.getString("fancy-value", "&7Ping: %ping%"), section.getString("disable-condition", "%world%=disabledworld"), Arrays.asList("%health%", "%player_health%", "%player_health_rounded%").contains(value) ? Scoreboard.HealthDisplay.HEARTS : Scoreboard.HealthDisplay.INTEGER);
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @NotNull
    public String getFancyValue() {
        return this.fancyValue;
    }

    @NotNull
    public String getDisableCondition() {
        return this.disableCondition;
    }

    @NotNull
    public Scoreboard.HealthDisplay getHealthDisplay() {
        return this.healthDisplay;
    }

    public PlayerListObjectiveConfiguration(@NotNull String value, @NotNull String fancyValue, @NotNull String disableCondition, @NotNull Scoreboard.HealthDisplay healthDisplay) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (fancyValue == null) {
            throw new NullPointerException("fancyValue is marked non-null but is null");
        }
        if (disableCondition == null) {
            throw new NullPointerException("disableCondition is marked non-null but is null");
        }
        if (healthDisplay == null) {
            throw new NullPointerException("healthDisplay is marked non-null but is null");
        }
        this.value = value;
        this.fancyValue = fancyValue;
        this.disableCondition = disableCondition;
        this.healthDisplay = healthDisplay;
    }
}

