/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.playerlistobjective;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.playerlistobjective.PlayerListObjectiveConfiguration;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RedisFeature;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.OnlinePlayers;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YellowNumber
extends RefreshableFeature
implements JoinListener,
QuitListener,
Loadable,
CustomThreaded,
RedisFeature {
    public static final String OBJECTIVE_NAME = "TAB-PlayerList";
    private static final TabComponent TITLE = new SimpleComponent("Java Edition is better");
    private final StringToComponentCache cache = new StringToComponentCache("Playerlist Objective", 1000);
    private final ThreadExecutor customThread = new ThreadExecutor("TAB Playerlist Objective Thread");
    private OnlinePlayers onlinePlayers;
    private final PlayerListObjectiveConfiguration configuration;
    private final DisableChecker disableChecker;
    @Nullable
    private final RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");

    public YellowNumber(@NotNull PlayerListObjectiveConfiguration configuration) {
        this.configuration = configuration;
        this.disableChecker = new DisableChecker(this, Condition.getCondition(configuration.getDisableCondition()), this::onDisableConditionChange, p -> p.playerlistObjectiveData.disabled);
        TAB.getInstance().getFeatureManager().registerFeature("YellowNumber-Condition", this.disableChecker);
        if (this.redis != null) {
            this.redis.registerMessage("yellow-number", UpdateRedisPlayer.class, () -> new UpdateRedisPlayer());
        }
    }

    public int getValueNumber(@NotNull TabPlayer p) {
        String string = p.playerlistObjectiveData.valueLegacy.updateAndGet();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            try {
                int value = (int)Math.round(Double.parseDouble(string));
                TAB.getInstance().getConfigHelper().runtime().floatInPlayerlistObjective(p, this.configuration.getValue(), string);
                return value;
            }
            catch (NumberFormatException e2) {
                TAB.getInstance().getConfigHelper().runtime().invalidNumberForPlayerlistObjective(p, this.configuration.getValue(), string);
                return 0;
            }
        }
    }

    @Override
    public void load() {
        this.onlinePlayers = new OnlinePlayers(TAB.getInstance().getOnlinePlayers());
        HashMap<TabPlayer, Integer> values = new HashMap<TabPlayer, Integer>();
        for (TabPlayer loaded : this.onlinePlayers.getPlayers()) {
            loaded.playerlistObjectiveData.valueLegacy = new Property(this, loaded, this.configuration.getValue());
            loaded.playerlistObjectiveData.valueModern = new Property(this, loaded, this.configuration.getFancyValue());
            if (this.disableChecker.isDisableConditionMet(loaded)) {
                loaded.playerlistObjectiveData.disabled.set(true);
            } else {
                this.register(loaded);
            }
            values.put(loaded, this.getValueNumber(loaded));
            if (this.redis == null) continue;
            this.redis.sendMessage(new UpdateRedisPlayer(loaded.getTablistId(), (Integer)values.get(loaded), loaded.playerlistObjectiveData.valueModern.get()));
        }
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            for (Map.Entry entry : values.entrySet()) {
                this.setScore(viewer, (TabPlayer)entry.getKey(), (Integer)entry.getValue(), ((TabPlayer)entry.getKey()).playerlistObjectiveData.valueModern.getFormat(viewer));
            }
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.onlinePlayers.addPlayer(connectedPlayer);
        connectedPlayer.playerlistObjectiveData.valueLegacy = new Property(this, connectedPlayer, this.configuration.getValue());
        connectedPlayer.playerlistObjectiveData.valueModern = new Property(this, connectedPlayer, this.configuration.getFancyValue());
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.playerlistObjectiveData.disabled.set(true);
        } else {
            this.register(connectedPlayer);
        }
        int value = this.getValueNumber(connectedPlayer);
        Property valueFancy = connectedPlayer.playerlistObjectiveData.valueModern;
        valueFancy.update();
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            this.setScore(all, connectedPlayer, value, valueFancy.getFormat(connectedPlayer));
            if (all == connectedPlayer) continue;
            this.setScore(connectedPlayer, all, this.getValueNumber(all), all.playerlistObjectiveData.valueModern.getFormat(connectedPlayer));
        }
        if (this.redis != null) {
            this.redis.sendMessage(new UpdateRedisPlayer(connectedPlayer.getTablistId(), this.getValueNumber(connectedPlayer), connectedPlayer.playerlistObjectiveData.valueModern.get()));
            if (connectedPlayer.playerlistObjectiveData.disabled.get()) {
                return;
            }
            for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                if (redis.getPlayerlistFancy() == null) continue;
                connectedPlayer.getScoreboard().setScore(OBJECTIVE_NAME, redis.getNickname(), redis.getPlayerlistNumber(), null, redis.getPlayerlistFancy());
            }
        }
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        if (disabledNow) {
            p.getScoreboard().unregisterObjective(OBJECTIVE_NAME);
        } else {
            this.register(p);
            for (TabPlayer all : this.onlinePlayers.getPlayers()) {
                this.setScore(p, all, this.getValueNumber(all), all.playerlistObjectiveData.valueModern.getFormat(p));
            }
            if (this.redis != null) {
                this.redis.sendMessage(new UpdateRedisPlayer(p.getTablistId(), this.getValueNumber(p), p.playerlistObjectiveData.valueModern.get()));
                for (RedisPlayer redis : this.redis.getRedisPlayers().values()) {
                    if (redis.getPlayerlistFancy() == null) continue;
                    p.getScoreboard().setScore(OBJECTIVE_NAME, redis.getNickname(), redis.getPlayerlistNumber(), null, redis.getPlayerlistFancy());
                }
            }
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating value";
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        if (refreshed.playerlistObjectiveData.valueLegacy == null) {
            return;
        }
        int value = this.getValueNumber(refreshed);
        refreshed.playerlistObjectiveData.valueModern.update();
        for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
            this.setScore(viewer, refreshed, value, refreshed.playerlistObjectiveData.valueModern.getFormat(viewer));
        }
        if (this.redis != null) {
            this.redis.sendMessage(new UpdateRedisPlayer(refreshed.getTablistId(), value, refreshed.playerlistObjectiveData.valueModern.get()));
        }
    }

    private void register(@NotNull TabPlayer player) {
        player.getScoreboard().registerObjective(Scoreboard.DisplaySlot.PLAYER_LIST, OBJECTIVE_NAME, TITLE, this.configuration.getHealthDisplay(), new SimpleComponent(""));
    }

    public void setScore(@NotNull TabPlayer viewer, @NotNull TabPlayer scoreHolder, int value, @NotNull String fancyValue) {
        if (viewer.playerlistObjectiveData.disabled.get()) {
            return;
        }
        viewer.getScoreboard().setScore(OBJECTIVE_NAME, scoreHolder.getNickname(), value, null, (TabComponent)this.cache.get(fancyValue));
    }

    public void processNicknameChange(@NotNull TabPlayer player) {
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            int value = this.getValueNumber(player);
            for (TabPlayer viewer : this.onlinePlayers.getPlayers()) {
                this.setScore(viewer, player, value, player.playerlistObjectiveData.valueModern.get());
            }
        }, this.getFeatureName(), "Processing nickname change"));
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        this.onlinePlayers.removePlayer(disconnectedPlayer);
    }

    @Override
    public void onRedisLoadRequest() {
        for (TabPlayer all : this.onlinePlayers.getPlayers()) {
            this.redis.sendMessage(new UpdateRedisPlayer(all.getTablistId(), this.getValueNumber(all), all.playerlistObjectiveData.valueModern.get()));
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Playerlist Objective";
    }

    public StringToComponentCache getCache() {
        return this.cache;
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    public OnlinePlayers getOnlinePlayers() {
        return this.onlinePlayers;
    }

    private class UpdateRedisPlayer
    extends RedisMessage {
        private UUID playerId;
        private int value;
        private String fancyValue;

        @Override
        @NotNull
        public ThreadExecutor getCustomThread() {
            return YellowNumber.this.customThread;
        }

        @Override
        public void write(@NotNull ByteArrayDataOutput out) {
            this.writeUUID(out, this.playerId);
            out.writeInt(this.value);
            out.writeUTF(this.fancyValue);
        }

        @Override
        public void read(@NotNull ByteArrayDataInput in) {
            this.playerId = this.readUUID(in);
            this.value = in.readInt();
            this.fancyValue = in.readUTF();
        }

        @Override
        public void process(@NotNull RedisSupport redisSupport) {
            RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
            if (target == null) {
                TAB.getInstance().getErrorManager().printError("Unable to process Playerlist objective update of redis player " + this.playerId + ", because no such player exists", null);
                return;
            }
            if (target.getPlayerlistFancy() == null) {
                TAB.getInstance().debug("Processing playerlist objective join of redis player " + target.getName());
            }
            target.setPlayerlistNumber(this.value);
            target.setPlayerlistFancy((TabComponent)YellowNumber.this.cache.get(this.fancyValue));
            for (TabPlayer viewer : YellowNumber.this.onlinePlayers.getPlayers()) {
                if (viewer.playerlistObjectiveData.disabled.get()) continue;
                viewer.getScoreboard().setScore(YellowNumber.OBJECTIVE_NAME, target.getNickname(), target.getPlayerlistNumber(), null, target.getPlayerlistFancy());
            }
        }

        public UpdateRedisPlayer() {
        }

        public UpdateRedisPlayer(UUID playerId, int value, String fancyValue) {
            this.playerId = playerId;
            this.value = value;
            this.fancyValue = fancyValue;
        }
    }

    public static class PlayerData {
        public Property valueLegacy;
        public Property valueModern;
        public final AtomicBoolean disabled = new AtomicBoolean();
    }
}

