/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.neznamy.tab.api.event.EventHandler;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.event.impl.TabPlaceholderRegisterEvent;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.message.Load;
import me.neznamy.tab.shared.features.redis.message.LoadRequest;
import me.neznamy.tab.shared.features.redis.message.PlayerJoin;
import me.neznamy.tab.shared.features.redis.message.PlayerQuit;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.features.redis.message.ServerSwitch;
import me.neznamy.tab.shared.features.redis.message.UpdateVanishStatus;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.PerformanceUtil;
import org.jetbrains.annotations.NotNull;

public abstract class RedisSupport
extends TabFeature
implements JoinListener,
QuitListener,
Loadable,
UnLoadable,
ServerSwitchListener,
VanishListener {
    @NotNull
    protected final Map<UUID, RedisPlayer> redisPlayers = new ConcurrentHashMap<UUID, RedisPlayer>();
    @NotNull
    private final UUID proxy = UUID.randomUUID();
    private EventHandler<TabPlaceholderRegisterEvent> eventHandler;
    @NotNull
    private final Map<String, Supplier<RedisMessage>> messages = new HashMap<String, Supplier<RedisMessage>>();
    @NotNull
    private final Map<Class<? extends RedisMessage>, String> classStringMap = new HashMap<Class<? extends RedisMessage>, String>();

    protected RedisSupport() {
        this.registerMessage("load", Load.class, Load::new);
        this.registerMessage("loadrequest", LoadRequest.class, LoadRequest::new);
        this.registerMessage("join", PlayerJoin.class, PlayerJoin::new);
        this.registerMessage("quit", PlayerQuit.class, PlayerQuit::new);
        this.registerMessage("server", ServerSwitch.class, ServerSwitch::new);
        this.registerMessage("vanish", UpdateVanishStatus.class, UpdateVanishStatus::new);
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "RedisSupport";
    }

    public void processMessage(@NotNull String msg) {
        TAB.getInstance().getCpu().runMeasuredTask(this.getFeatureName(), "Redis Message processing", () -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])Base64.getDecoder().decode(msg));
            String proxy = in.readUTF();
            if (proxy.equals(this.proxy.toString())) {
                return;
            }
            String action = in.readUTF();
            Supplier<RedisMessage> supplier = this.messages.get(action);
            if (supplier == null) {
                TAB.getInstance().getErrorManager().unknownRedisMessage(action);
                return;
            }
            RedisMessage redisMessage = supplier.get();
            redisMessage.read(in);
            if (redisMessage.getCustomThread() != null) {
                redisMessage.getCustomThread().execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> redisMessage.process(this), this.getFeatureName(), "Redis Message processing"));
            } else {
                redisMessage.process(this);
            }
        });
    }

    public abstract void sendMessage(@NotNull String var1);

    public abstract void register();

    public abstract void unregister();

    @Override
    public void load() {
        this.register();
        this.overridePlaceholders();
        TAB.getInstance().getEventBus().register(TabPlaceholderRegisterEvent.class, this.eventHandler);
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
        this.sendMessage(new LoadRequest());
    }

    private void overridePlaceholders() {
        this.eventHandler = event -> {
            String identifier = event.getIdentifier();
            if (identifier.startsWith("%online_")) {
                String server = identifier.substring(8, identifier.length() - 1);
                event.setServerPlaceholder(() -> {
                    int count = 0;
                    for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                        if (!player.server.equals(server) || player.isVanished()) continue;
                        ++count;
                    }
                    for (RedisPlayer player : this.redisPlayers.values()) {
                        if (!player.server.equals(server) || player.isVanished()) continue;
                        ++count;
                    }
                    return PerformanceUtil.toString(count);
                });
            }
        };
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%online%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished()) continue;
                ++count;
            }
            for (RedisPlayer player : this.redisPlayers.values()) {
                if (player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%staffonline%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished() || !player.hasPermission("tab.staff")) continue;
                ++count;
            }
            for (RedisPlayer player : this.redisPlayers.values()) {
                if (player.isVanished() || !player.isStaff()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%serveronline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!((TabPlayer)p).server.equals(player.server) || player.isVanished()) continue;
                ++count;
            }
            for (RedisPlayer player : this.redisPlayers.values()) {
                if (!((TabPlayer)p).server.equals(player.server) || player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onQuit(p);
        }
        TAB.getInstance().getEventBus().unregister(this.eventHandler);
        this.unregister();
    }

    @Override
    public void onJoin(@NotNull TabPlayer p) {
        this.sendMessage(new PlayerJoin(p));
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        this.sendMessage(new ServerSwitch(p.getTablistId(), to));
    }

    @Override
    public void onQuit(@NotNull TabPlayer p) {
        this.sendMessage(new PlayerQuit(p.getTablistId()));
    }

    public void sendMessage(@NotNull RedisMessage message) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.proxy.toString());
        out.writeUTF(this.classStringMap.get(message.getClass()));
        message.write(out);
        this.sendMessage(Base64.getEncoder().encodeToString(out.toByteArray()));
    }

    public void registerMessage(@NotNull String name, @NotNull Class<? extends RedisMessage> clazz, @NotNull Supplier<RedisMessage> supplier) {
        this.messages.put(name, supplier);
        this.classStringMap.put(clazz, name);
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        this.sendMessage(new UpdateVanishStatus(player.getTablistId(), player.isVanished()));
    }

    @NotNull
    public Map<UUID, RedisPlayer> getRedisPlayers() {
        return this.redisPlayers;
    }

    @NotNull
    public UUID getProxy() {
        return this.proxy;
    }

    public EventHandler<TabPlaceholderRegisterEvent> getEventHandler() {
        return this.eventHandler;
    }

    @NotNull
    public Map<String, Supplier<RedisMessage>> getMessages() {
        return this.messages;
    }

    @NotNull
    public Map<Class<? extends RedisMessage>, String> getClassStringMap() {
        return this.classStringMap;
    }
}

