/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.message;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class PlayerJoin
extends RedisMessage {
    private RedisPlayer decodedPlayer;
    private TabPlayer encodedPlayer;

    public PlayerJoin(@NotNull TabPlayer encodedPlayer) {
        this.encodedPlayer = encodedPlayer;
    }

    @Override
    public void write(@NotNull ByteArrayDataOutput out) {
        this.writeUUID(out, this.encodedPlayer.getTablistId());
        out.writeUTF(this.encodedPlayer.getName());
        out.writeUTF(this.encodedPlayer.server);
        out.writeBoolean(this.encodedPlayer.isVanished());
        out.writeBoolean(this.encodedPlayer.hasPermission("tab.staff"));
        out.writeBoolean(this.encodedPlayer.getSkin() != null);
        if (this.encodedPlayer.getSkin() != null) {
            out.writeUTF(this.encodedPlayer.getSkin().getValue());
            out.writeBoolean(this.encodedPlayer.getSkin().getSignature() != null);
            if (this.encodedPlayer.getSkin().getSignature() != null) {
                out.writeUTF(this.encodedPlayer.getSkin().getSignature());
            }
        }
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in) {
        UUID uniqueId = this.readUUID(in);
        String name = in.readUTF();
        String server = in.readUTF();
        boolean vanished = in.readBoolean();
        boolean staff = in.readBoolean();
        this.decodedPlayer = new RedisPlayer(uniqueId, name, name, server, vanished, staff);
        if (in.readBoolean()) {
            String value = in.readUTF();
            String signature = null;
            if (in.readBoolean()) {
                signature = in.readUTF();
            }
            this.decodedPlayer.setSkin(new TabList.Skin(value, signature));
        }
    }

    @Override
    public void process(@NotNull RedisSupport redisSupport) {
        TAB.getInstance().debug("Processing join of redis player " + this.decodedPlayer.getName() + " (" + this.decodedPlayer.getUniqueId() + ")");
        redisSupport.getRedisPlayers().put(this.decodedPlayer.getUniqueId(), this.decodedPlayer);
        TAB.getInstance().getFeatureManager().onJoin(this.decodedPlayer);
    }

    public PlayerJoin() {
    }

    public RedisPlayer getDecodedPlayer() {
        return this.decodedPlayer;
    }
}

