/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.api.scoreboard.ScoreboardManager;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.cpu.ThreadExecutor;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardConfiguration;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;
import me.neznamy.tab.shared.features.types.CommandListener;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.DisplayObjectiveListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.ObjectiveListener;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardManagerImpl
extends RefreshableFeature
implements ScoreboardManager,
JoinListener,
CommandListener,
DisplayObjectiveListener,
ObjectiveListener,
Loadable,
QuitListener,
CustomThreaded,
ServerSwitchListener {
    public static final String OBJECTIVE_NAME = "TAB-Scoreboard";
    private final StringToComponentCache cache = new StringToComponentCache("Scoreboard", 1000);
    private final ThreadExecutor customThread = new ThreadExecutor("TAB Scoreboard Thread");
    private final ScoreboardConfiguration configuration;
    private final Map<String, Scoreboard> registeredScoreboards = new LinkedHashMap<String, Scoreboard>();
    private Scoreboard[] definedScoreboards;
    private final List<String> sbOffPlayers;
    @Nullable
    private Scoreboard announcement;

    public ScoreboardManagerImpl(@NotNull ScoreboardConfiguration configuration) {
        this.configuration = configuration;
        this.sbOffPlayers = configuration.isRememberToggleChoice() ? TAB.getInstance().getConfiguration().getPlayerDataFile().getStringList("scoreboard-off", new ArrayList<String>()) : Collections.emptyList();
    }

    @Override
    public void load() {
        for (Map.Entry<String, ScoreboardConfiguration.ScoreboardDefinition> entry : this.configuration.getScoreboards().entrySet()) {
            String scoreboardName = entry.getKey();
            ScoreboardImpl sb = new ScoreboardImpl(this, scoreboardName, entry.getValue());
            this.registeredScoreboards.put(scoreboardName, sb);
            TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.scoreboardLine(scoreboardName), sb);
        }
        this.definedScoreboards = this.registeredScoreboards.values().toArray(new Scoreboard[0]);
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Switching scoreboards";
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        if (p.scoreboardData.forcedScoreboard != null || !this.hasScoreboardVisible(p) || this.announcement != null || p.scoreboardData.otherPluginScoreboard != null || p.scoreboardData.joinDelayed) {
            return;
        }
        this.sendHighestScoreboard(p);
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        ((SafeScoreboard)connectedPlayer.getScoreboard()).setAntiOverrideScoreboard(true);
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setScoreboardName(connectedPlayer, "");
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setScoreboardVisible(connectedPlayer, false);
        if (this.configuration.getJoinDelay() > 0) {
            connectedPlayer.scoreboardData.joinDelayed = true;
            this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
                if (connectedPlayer.scoreboardData.otherPluginScoreboard == null) {
                    this.setScoreboardVisible(connectedPlayer, this.configuration.isHiddenByDefault() == this.sbOffPlayers.contains(connectedPlayer.getName()), false);
                }
                connectedPlayer.scoreboardData.joinDelayed = false;
            }, this.getFeatureName(), "Player Join"), this.configuration.getJoinDelay());
        } else {
            this.setScoreboardVisible(connectedPlayer, this.configuration.isHiddenByDefault() == this.sbOffPlayers.contains(connectedPlayer.getName()), false);
        }
    }

    public void sendHighestScoreboard(@NonNull TabPlayer p) {
        ScoreboardImpl current;
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (!this.hasScoreboardVisible(p)) {
            return;
        }
        ScoreboardImpl scoreboard = (ScoreboardImpl)this.detectHighestScoreboard(p);
        if (scoreboard != (current = p.scoreboardData.activeScoreboard)) {
            if (current != null) {
                current.removePlayer(p);
            }
            if (scoreboard != null) {
                scoreboard.addPlayer(p);
            }
        }
    }

    public void unregisterScoreboard(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (p.scoreboardData.activeScoreboard != null) {
            p.scoreboardData.activeScoreboard.removePlayer(p);
            p.scoreboardData.activeScoreboard = null;
        }
    }

    @Nullable
    public Scoreboard detectHighestScoreboard(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (p.scoreboardData.forcedScoreboard != null) {
            return p.scoreboardData.forcedScoreboard;
        }
        for (Scoreboard sb : this.definedScoreboards) {
            if (!((ScoreboardImpl)sb).isConditionMet(p)) continue;
            return sb;
        }
        return null;
    }

    @Override
    public boolean onCommand(@NotNull TabPlayer sender, @NotNull String message) {
        if (message.equals(this.configuration.getToggleCommand())) {
            TAB.getInstance().getCommand().execute(sender, new String[]{"scoreboard"});
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getCommand() {
        return this.configuration.getToggleCommand();
    }

    @Override
    public void onDisplayObjective(@NotNull TabPlayer receiver, int slot, @NotNull String objective) {
        if (slot == Scoreboard.DisplaySlot.SIDEBAR.ordinal() && !objective.equals(OBJECTIVE_NAME)) {
            TAB.getInstance().debug("Player " + receiver.getName() + " received scoreboard called " + objective + ", hiding TAB one.");
            receiver.scoreboardData.otherPluginScoreboard = objective;
            ScoreboardImpl sb = receiver.scoreboardData.activeScoreboard;
            if (sb != null) {
                sb.removePlayer(receiver);
            }
        }
    }

    @Override
    public void onObjective(@NotNull TabPlayer receiver, int action, @NotNull String objective) {
        if (action == 1 && objective.equals(receiver.scoreboardData.otherPluginScoreboard)) {
            TAB.getInstance().debug("Player " + receiver.getName() + " no longer has another scoreboard, sending TAB one.");
            receiver.scoreboardData.otherPluginScoreboard = null;
            this.sendHighestScoreboard(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlayers() {
        List<String> list = this.sbOffPlayers;
        synchronized (list) {
            TAB.getInstance().getConfiguration().getPlayerDataFile().set("scoreboard-off", new ArrayList<String>(this.sbOffPlayers));
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        ScoreboardImpl sb = disconnectedPlayer.scoreboardData.activeScoreboard;
        if (sb != null) {
            sb.removePlayerFromSet(disconnectedPlayer);
        }
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NonNull String name, @NonNull String title, @NonNull List<String> lines) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        this.ensureActive();
        ScoreboardImpl sb = new ScoreboardImpl(this, name, new ScoreboardConfiguration.ScoreboardDefinition(null, title, lines), true);
        this.registeredScoreboards.put(name, sb);
        this.definedScoreboards = this.registeredScoreboards.values().toArray(new Scoreboard[0]);
        return sb;
    }

    @Override
    public void showScoreboard(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull Scoreboard scoreboard) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (scoreboard == null) {
            throw new NullPointerException("scoreboard is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (p.scoreboardData.forcedScoreboard != null) {
            p.scoreboardData.forcedScoreboard.removePlayer(p);
        }
        p.scoreboardData.forcedScoreboard = (ScoreboardImpl)scoreboard;
        if (p.scoreboardData.activeScoreboard != null) {
            p.scoreboardData.activeScoreboard.removePlayer(p);
            p.scoreboardData.activeScoreboard = null;
        }
        if (this.hasScoreboardVisible(player)) {
            ((ScoreboardImpl)scoreboard).addPlayer(p);
        }
    }

    @Override
    public boolean hasCustomScoreboard(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).scoreboardData.forcedScoreboard != null;
    }

    @Override
    public void resetScoreboard(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (p.scoreboardData.forcedScoreboard != null) {
            p.scoreboardData.forcedScoreboard.removePlayer(p);
            p.scoreboardData.forcedScoreboard = null;
            Scoreboard sb = this.detectHighestScoreboard(p);
            if (sb == null) {
                return;
            }
            p.scoreboardData.activeScoreboard = (ScoreboardImpl)sb;
            ((ScoreboardImpl)sb).addPlayer(p);
        }
    }

    @Override
    public boolean hasScoreboardVisible(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).scoreboardData.visible;
    }

    @Override
    public void setScoreboardVisible(@NonNull me.neznamy.tab.api.TabPlayer p, boolean visible, boolean sendToggleMessage) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        if (player.scoreboardData.visible == visible) {
            return;
        }
        if (visible) {
            player.scoreboardData.visible = true;
            this.sendHighestScoreboard(player);
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getScoreboardOn(), true);
            }
            if (this.configuration.isRememberToggleChoice()) {
                if (this.configuration.isHiddenByDefault()) {
                    if (!this.sbOffPlayers.contains(player.getName())) {
                        this.sbOffPlayers.add(player.getName());
                        this.savePlayers();
                    }
                } else if (this.sbOffPlayers.remove(player.getName())) {
                    this.savePlayers();
                }
            }
        } else {
            player.scoreboardData.visible = false;
            this.unregisterScoreboard(player);
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getScoreboardOff(), true);
            }
            if (this.configuration.isRememberToggleChoice()) {
                if (this.configuration.isHiddenByDefault()) {
                    if (this.sbOffPlayers.remove(player.getName())) {
                        this.savePlayers();
                    }
                } else if (!this.sbOffPlayers.contains(player.getName())) {
                    this.sbOffPlayers.add(player.getName());
                    this.savePlayers();
                }
            }
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setScoreboardVisible(player, visible);
    }

    @Override
    public void toggleScoreboard(@NonNull me.neznamy.tab.api.TabPlayer player, boolean sendToggleMessage) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.setScoreboardVisible(player, !((TabPlayer)player).scoreboardData.visible, sendToggleMessage);
    }

    @Override
    public void announceScoreboard(@NonNull String scoreboard, int duration) {
        if (scoreboard == null) {
            throw new NullPointerException("scoreboard is marked non-null but is null");
        }
        this.ensureActive();
        if (duration < 0) {
            throw new IllegalArgumentException("Duration cannot be negative");
        }
        ScoreboardImpl sb = (ScoreboardImpl)this.registeredScoreboards.get(scoreboard);
        if (sb == null) {
            throw new IllegalArgumentException("No registered scoreboard found with name " + scoreboard);
        }
        HashMap previous = new HashMap();
        this.customThread.execute(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            this.announcement = sb;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!this.hasScoreboardVisible(all)) continue;
                previous.put(all, all.scoreboardData.activeScoreboard);
                if (all.scoreboardData.activeScoreboard != null) {
                    all.scoreboardData.activeScoreboard.removePlayer(all);
                }
                sb.addPlayer(all);
            }
        }, this.getFeatureName(), "Adding announced Scoreboard"));
        this.customThread.executeLater(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!this.hasScoreboardVisible(all)) continue;
                sb.removePlayer(all);
                if (previous.get(all) == null) continue;
                ((ScoreboardImpl)previous.get(all)).addPlayer(all);
            }
            this.announcement = null;
        }, this.getFeatureName(), "Removing announced Scoreboard"), duration * 1000);
    }

    @Override
    @Nullable
    public ScoreboardImpl getActiveScoreboard(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).scoreboardData.activeScoreboard;
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Scoreboard";
    }

    @Override
    public void onServerChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        if (changed.scoreboardData.otherPluginScoreboard != null) {
            changed.scoreboardData.otherPluginScoreboard = null;
            this.sendHighestScoreboard(changed);
        }
    }

    public StringToComponentCache getCache() {
        return this.cache;
    }

    @Override
    public ThreadExecutor getCustomThread() {
        return this.customThread;
    }

    public ScoreboardConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, Scoreboard> getRegisteredScoreboards() {
        return this.registeredScoreboards;
    }

    public static class PlayerData {
        public boolean joinDelayed;
        public boolean visible;
        @Nullable
        public ScoreboardImpl activeScoreboard;
        @Nullable
        public ScoreboardImpl forcedScoreboard;
        @Nullable
        public String otherPluginScoreboard;
        @Nullable
        public Property titleProperty;
        @NotNull
        public final Map<ScoreboardLine, Property> lineProperties = new IdentityHashMap<ScoreboardLine, Property>();
        @NotNull
        public final Map<ScoreboardLine, Property> lineNameProperties = new IdentityHashMap<ScoreboardLine, Property>();
        @NotNull
        public final Map<ScoreboardLine, Property> numberFormatProperties = new IdentityHashMap<ScoreboardLine, Property>();
    }
}

