/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.types;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.RefreshableFeature;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableChecker
extends RefreshableFeature {
    @NotNull
    private final TabFeature feature;
    @Nullable
    private final Condition disableCondition;
    @NotNull
    private final BiConsumer<TabPlayer, Boolean> action;
    @NotNull
    private final Function<TabPlayer, AtomicBoolean> field;

    public DisableChecker(@NotNull TabFeature feature, @Nullable Condition disableCondition, @NotNull BiConsumer<TabPlayer, Boolean> action, @NotNull Function<TabPlayer, AtomicBoolean> field) {
        this.feature = feature;
        this.disableCondition = disableCondition;
        this.action = action;
        this.field = field;
        if (disableCondition != null) {
            this.addUsedPlaceholder(TabConstants.Placeholder.condition(disableCondition.getName()));
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Refreshing disable condition";
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        if (this.disableCondition == null) {
            return;
        }
        Runnable r = () -> {
            AtomicBoolean value;
            boolean disabledNow = this.disableCondition.isMet(refreshed);
            if (disabledNow == (value = this.field.apply(refreshed)).get()) {
                return;
            }
            value.set(disabledNow);
            this.action.accept(refreshed, disabledNow);
        };
        if (this.feature instanceof CustomThreaded) {
            ((CustomThreaded)((Object)this.feature)).getCustomThread().execute(new TimedCaughtTask(TAB.getInstance().getCpu(), r, this.feature.getFeatureName(), "Refreshing disable condition"));
        } else {
            r.run();
        }
    }

    public boolean isDisableConditionMet(TabPlayer p) {
        return this.disableCondition != null && this.disableCondition.isMet(p);
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.feature.getFeatureName();
    }
}

