/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.hook;

import java.util.ArrayList;
import java.util.EnumSet;
import me.neznamy.tab.shared.chat.ChatModifier;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventureHook {
    private static final EnumSet<TextDecoration>[] decorations = AdventureHook.loadDecorations();

    private static EnumSet<TextDecoration>[] loadDecorations() {
        EnumSet[] decorations = new EnumSet[32];
        for (int i = 0; i < 32; ++i) {
            EnumSet<TextDecoration> set = EnumSet.noneOf(TextDecoration.class);
            if ((i & 1) > 0) {
                set.add(TextDecoration.BOLD);
            }
            if ((i & 2) > 0) {
                set.add(TextDecoration.ITALIC);
            }
            if ((i & 4) > 0) {
                set.add(TextDecoration.OBFUSCATED);
            }
            if ((i & 8) > 0) {
                set.add(TextDecoration.STRIKETHROUGH);
            }
            if ((i & 0x10) > 0) {
                set.add(TextDecoration.UNDERLINED);
            }
            decorations[i] = set;
        }
        return decorations;
    }

    @NotNull
    public static Component toAdventureComponent(@NotNull TabComponent component, boolean modern) {
        if (component instanceof SimpleComponent) {
            return Component.text((String)((SimpleComponent)component).getText());
        }
        StructuredComponent iComponent = (StructuredComponent)component;
        ChatModifier modifier = iComponent.getModifier();
        TextComponent adventureComponent = Component.text((String)iComponent.getText(), (TextColor)AdventureHook.convertColor(modifier.getColor(), modern), decorations[modifier.getMagicCodeBitMask()]);
        if (modifier.getFont() != null) {
            adventureComponent = adventureComponent.font(Key.key((String)modifier.getFont()));
        }
        if (!iComponent.getExtra().isEmpty()) {
            ArrayList<Component> list = new ArrayList<Component>();
            for (StructuredComponent extra : iComponent.getExtra()) {
                list.add(AdventureHook.toAdventureComponent(extra, modern));
            }
            adventureComponent = adventureComponent.children(list);
        }
        return adventureComponent;
    }

    @Nullable
    private static TextColor convertColor(@Nullable me.neznamy.tab.shared.chat.TextColor color, boolean rgbSupport) {
        if (color == null) {
            return null;
        }
        if (rgbSupport) {
            return TextColor.color((int)color.getRgb());
        }
        return TextColor.color((int)color.getLegacyColor().getRgb());
    }
}

