/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Map;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.hook.LuckPermsHook;
import me.neznamy.tab.shared.placeholders.PlaceholdersConfiguration;
import me.neznamy.tab.shared.placeholders.animation.Animation;
import me.neznamy.tab.shared.placeholders.animation.AnimationConfiguration;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.placeholders.conditions.ConditionsSection;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.PerformanceUtil;
import org.jetbrains.annotations.NotNull;

public class UniversalPlaceholderRegistry {
    private final DecimalFormat decimal2;

    public UniversalPlaceholderRegistry() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        this.decimal2 = new DecimalFormat("#.##", symbols);
    }

    public void registerPlaceholders(@NotNull PlaceholderManager manager) {
        this.registerConstants(manager);
        this.registerServerPlaceholders(manager);
        this.registerPlayerPlaceholders(manager);
    }

    private void registerConstants(@NotNull PlaceholderManager manager) {
        manager.registerPlayerPlaceholder("%bedrock%", -1, p -> Boolean.toString(((TabPlayer)p).isBedrockPlayer()));
        manager.registerPlayerPlaceholder("%player%", -1, me.neznamy.tab.api.TabPlayer::getName);
        manager.registerPlayerPlaceholder("%world%", -1, p -> ((TabPlayer)p).world);
        manager.registerPlayerPlaceholder("%server%", -1, p -> ((TabPlayer)p).server);
        manager.registerPlayerPlaceholder("%player-version%", -1, p -> ((TabPlayer)p).getVersion().getFriendlyName());
        manager.registerPlayerPlaceholder("%player-version-id%", -1, p -> PerformanceUtil.toString(((TabPlayer)p).getVersion().getNetworkId()));
        manager.registerServerPlaceholder("%%", -1, () -> "%");
        manager.registerServerPlaceholder("%memory-max%", -1, () -> PerformanceUtil.toString((int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L)));
        manager.registerServerPlaceholder("%memory-max-gb%", -1, () -> this.decimal2.format((float)Runtime.getRuntime().maxMemory() / 1024.0f / 1024.0f / 1024.0f));
        if (!LuckPermsHook.getInstance().isInstalled()) {
            manager.registerServerPlaceholder("%luckperms-prefix%", -1, () -> "");
            manager.registerServerPlaceholder("%luckperms-suffix%", -1, () -> "");
        }
    }

    private void registerServerPlaceholders(@NotNull PlaceholderManager manager) {
        PlaceholdersConfiguration placeholders = TAB.getInstance().getConfiguration().getConfig().getPlaceholders();
        manager.registerServerPlaceholder("%time%", 500, () -> placeholders.getTimeFormat().format(new Date(System.currentTimeMillis() + (long)((int)(placeholders.getTimeOffset() * 3600000.0)))));
        manager.registerServerPlaceholder("%date%", 60000, () -> placeholders.getDateFormat().format(new Date(System.currentTimeMillis() + (long)((int)(placeholders.getTimeOffset() * 3600000.0)))));
        manager.registerServerPlaceholder("%memory-used%", 200, () -> PerformanceUtil.toString((int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L)));
        manager.registerServerPlaceholder("%memory-used-gb%", 200, () -> this.decimal2.format((float)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0f / 1024.0f / 1024.0f));
        manager.registerServerPlaceholder("%online%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        manager.registerServerPlaceholder("%staffonline%", 2000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!player.hasPermission("tab.staff") || player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        manager.registerServerPlaceholder("%nonstaffonline%", 2000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.hasPermission("tab.staff") || player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
    }

    private void registerPlayerPlaceholders(@NotNull PlaceholderManager manager) {
        boolean proxy = TAB.getInstance().getPlatform().isProxy();
        manager.registerPlayerPlaceholder("%group%", -1, me.neznamy.tab.api.TabPlayer::getGroup);
        manager.registerPlayerPlaceholder("%ping%", 500, p -> PerformanceUtil.toString(((TabPlayer)p).getPing()));
        manager.registerPlayerPlaceholder("%vanished%", 1000, p -> Boolean.toString(((TabPlayer)p).isVanished()));
        manager.registerPlayerPlaceholder("%worldonline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!((TabPlayer)p).world.equals(player.world) || player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        manager.registerPlayerPlaceholder("%serveronline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!((TabPlayer)p).server.equals(player.server) || player.isVanished()) continue;
                ++count;
            }
            return PerformanceUtil.toString(count);
        });
        manager.registerPlayerPlaceholder("%gamemode%", proxy ? -1 : 100, p -> PerformanceUtil.toString(((TabPlayer)p).getGamemode()));
        if (LuckPermsHook.getInstance().isInstalled()) {
            int refresh = TAB.getInstance().getConfiguration().getConfig().getPermissionRefreshInterval();
            manager.registerPlayerPlaceholder("%luckperms-prefix%", refresh, p -> LuckPermsHook.getInstance().getPrefix((TabPlayer)p));
            manager.registerPlayerPlaceholder("%luckperms-suffix%", refresh, p -> LuckPermsHook.getInstance().getSuffix((TabPlayer)p));
        }
        for (Map.Entry<String, AnimationConfiguration.AnimationDefinition> entry : TAB.getInstance().getConfiguration().getAnimations().getAnimations().getAnimations().entrySet()) {
            Animation a = new Animation((PlaceholderManagerImpl)manager, entry.getKey(), entry.getValue());
            manager.registerPlayerPlaceholder(TabConstants.Placeholder.animation(a.getName()), a.getRefresh(), p -> a.getMessage());
        }
        Condition.clearConditions();
        for (Map.Entry<String, Object> entry : TAB.getInstance().getConfiguration().getConfig().getConditions().getConditions().entrySet()) {
            ConditionsSection.ConditionDefinition def = (ConditionsSection.ConditionDefinition)entry.getValue();
            Condition c = new Condition(def.isType(), entry.getKey(), def.getConditions(), def.getYes(), def.getNo());
            manager.registerPlayerPlaceholder(TabConstants.Placeholder.condition(c.getName()), c.getRefresh(), p -> c.getText((TabPlayer)p));
        }
        Condition.finishSetups();
    }

    public DecimalFormat getDecimal2() {
        return this.decimal2;
    }
}

