/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.placeholders.conditions.FalseCondition;
import me.neznamy.tab.shared.placeholders.conditions.NumericCondition;
import me.neznamy.tab.shared.placeholders.conditions.StringCondition;
import me.neznamy.tab.shared.placeholders.conditions.TrueCondition;
import me.neznamy.tab.shared.placeholders.types.TabPlaceholder;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Condition {
    private static Map<String, Condition> registeredConditions = new HashMap<String, Condition>();
    private static final Map<String, Function<String, Function<TabPlayer, Boolean>>> conditionTypes = new LinkedHashMap<String, Function<String, Function<TabPlayer, Boolean>>>();
    private final String name;
    protected final List<Function<TabPlayer, Boolean>> subConditions = new ArrayList<Function<TabPlayer, Boolean>>();
    private final boolean type;
    private final String yes;
    private final String no;
    private int refresh = -1;
    private final List<String> placeholdersInConditions = new ArrayList<String>();

    @NotNull
    private static String[] splitAndTrim(@NotNull String string, @NonNull String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        return (String[])Arrays.stream(string.split(delimiter)).map(String::trim).toArray(String[]::new);
    }

    public Condition(boolean type, @NonNull String name, @NonNull List<String> conditions, @Nullable String yes, @Nullable String no) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
        this.yes = yes;
        this.no = no;
        for (String line : conditions) {
            Function<TabPlayer, Boolean> condition = Condition.compile(line);
            if (condition != null) {
                this.subConditions.add(condition);
                continue;
            }
            TAB.getInstance().getConfigHelper().startup().invalidConditionPattern(name, line);
        }
        for (String subCondition : conditions) {
            if (subCondition.startsWith("permission:")) {
                int permissionRefresh = TAB.getInstance().getConfiguration().getConfig().getPermissionRefreshInterval();
                if (this.refresh <= permissionRefresh && this.refresh != -1) continue;
                this.refresh = permissionRefresh;
                continue;
            }
            this.placeholdersInConditions.addAll(PlaceholderManagerImpl.detectPlaceholders(subCondition));
        }
        if (yes != null) {
            this.placeholdersInConditions.addAll(PlaceholderManagerImpl.detectPlaceholders(yes));
        }
        if (no != null) {
            this.placeholdersInConditions.addAll(PlaceholderManagerImpl.detectPlaceholders(no));
        }
        registeredConditions.put(name, this);
    }

    public void finishSetup() {
        for (String placeholder : this.placeholdersInConditions) {
            TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder).addParent(TabConstants.Placeholder.condition(this.name));
            TabPlaceholder pl = TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder);
            if (pl.getRefresh() >= this.refresh || pl.getRefresh() == -1) continue;
            this.refresh = pl.getRefresh();
        }
        TAB.getInstance().getPlaceholderManager().addUsedPlaceholders(this.placeholdersInConditions);
    }

    public String getText(TabPlayer p) {
        return this.isMet(p) ? this.yes : this.no;
    }

    public boolean isMet(TabPlayer p) {
        if (this.type) {
            for (Function<TabPlayer, Boolean> condition : this.subConditions) {
                if (condition.apply(p).booleanValue()) continue;
                return false;
            }
            return true;
        }
        for (Function<TabPlayer, Boolean> condition : this.subConditions) {
            if (!condition.apply(p).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Condition getCondition(String string) {
        List<String> conditions;
        boolean type;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.equals("true")) {
            return TrueCondition.INSTANCE;
        }
        if (string.equals("false")) {
            return FalseCondition.INSTANCE;
        }
        String anonVersion = "AnonymousCondition[" + string + "]";
        if (registeredConditions.containsKey(string)) {
            return registeredConditions.get(string);
        }
        if (registeredConditions.containsKey(anonVersion)) {
            return registeredConditions.get(anonVersion);
        }
        if (string.contains(";")) {
            type = true;
            conditions = Arrays.asList(string.split(";"));
        } else {
            type = false;
            conditions = Condition.splitString(string);
        }
        conditions = conditions.stream().map(String::trim).collect(Collectors.toList());
        Condition c = new Condition(type, anonVersion, conditions, "true", "false");
        c.finishSetup();
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(TabConstants.Placeholder.condition(c.name), c.refresh, p -> c.getText((TabPlayer)p));
        return c;
    }

    private static List<String> splitString(@NotNull String input) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(?<!-)[|](?!-)");
        Matcher matcher = pattern.matcher(input);
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start();
            result.add(input.substring(start, end));
            start = matcher.end();
        }
        result.add(input.substring(start));
        return result;
    }

    public static void clearConditions() {
        registeredConditions = new HashMap<String, Condition>();
    }

    public static void finishSetups() {
        for (Condition c : registeredConditions.values()) {
            c.finishSetup();
        }
    }

    private static Function<TabPlayer, Boolean> compile(String line) {
        for (Map.Entry<String, Function<String, Function<TabPlayer, Boolean>>> entry : conditionTypes.entrySet()) {
            if (!line.contains(entry.getKey())) continue;
            return entry.getValue().apply(line);
        }
        return null;
    }

    public static Map<String, Function<String, Function<TabPlayer, Boolean>>> getConditionTypes() {
        return conditionTypes;
    }

    public String getName() {
        return this.name;
    }

    public int getRefresh() {
        return this.refresh;
    }

    static {
        conditionTypes.put(">=", line -> new NumericCondition(Condition.splitAndTrim(line, ">="), (left, right) -> left >= right)::isMet);
        conditionTypes.put(">", line -> new NumericCondition(Condition.splitAndTrim(line, ">"), (left, right) -> left > right)::isMet);
        conditionTypes.put("<=", line -> new NumericCondition(Condition.splitAndTrim(line, "<="), (left, right) -> left <= right)::isMet);
        conditionTypes.put("<-", line -> new StringCondition(Condition.splitAndTrim(line, "<-"), String::contains)::isMet);
        conditionTypes.put("<", line -> new NumericCondition(Condition.splitAndTrim(line, "<"), (left, right) -> left < right)::isMet);
        conditionTypes.put("|-", line -> new StringCondition(Condition.splitAndTrim(line, "\\|-"), String::startsWith)::isMet);
        conditionTypes.put("-|", line -> new StringCondition(Condition.splitAndTrim(line, "-\\|"), String::endsWith)::isMet);
        conditionTypes.put("!=", line -> new StringCondition(Condition.splitAndTrim(line, "!="), (left, right) -> !left.equals(right))::isMet);
        conditionTypes.put("=", line -> new StringCondition(Condition.splitAndTrim(line, "="), String::equals)::isMet);
        conditionTypes.put("permission:", line -> {
            String node = Condition.splitAndTrim(line, ":")[1];
            return p -> p.hasPermission(node);
        });
    }
}

