/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.config.file.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class ConditionsSection {
    @NotNull
    private final Map<String, ConditionDefinition> conditions;

    @NotNull
    public static ConditionsSection fromSection(@NotNull ConfigurationSection section) {
        HashMap<String, ConditionDefinition> conditions = new HashMap<String, ConditionDefinition>();
        for (Object condition : section.getKeys()) {
            conditions.put(condition.toString(), ConditionDefinition.fromSection(section.getConfigurationSection(condition.toString()), condition.toString()));
        }
        return new ConditionsSection(conditions);
    }

    @NotNull
    public Map<String, ConditionDefinition> getConditions() {
        return this.conditions;
    }

    public ConditionsSection(@NotNull Map<String, ConditionDefinition> conditions) {
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        this.conditions = conditions;
    }

    public static class ConditionDefinition {
        @NotNull
        private final List<String> conditions;
        private final boolean type;
        @NotNull
        private final String yes;
        @NotNull
        private final String no;

        @NotNull
        public static ConditionDefinition fromSection(@NotNull ConfigurationSection section, @NotNull String name) {
            Object no;
            section.checkForUnknownKey(Arrays.asList("conditions", "type", "true", "false"));
            List<String> list = section.getStringList("conditions");
            if (list == null) {
                section.startupWarn("Condition \"" + name + "\" is missing \"conditions\" section.");
                list = Collections.emptyList();
            }
            String type = section.getString("type");
            Object yes = section.getObject("true");
            if (yes == null) {
                yes = "true";
            }
            if ((no = section.getObject("false")) == null) {
                no = "false";
            }
            if (list.size() >= 2 && type == null) {
                section.startupWarn(String.format("Condition \"%s\" has multiple conditions defined, but is missing \"type\" attribute. Using AND.", name));
            }
            return new ConditionDefinition(list, !"OR".equals(type), yes.toString(), no.toString());
        }

        @NotNull
        public List<String> getConditions() {
            return this.conditions;
        }

        public boolean isType() {
            return this.type;
        }

        @NotNull
        public String getYes() {
            return this.yes;
        }

        @NotNull
        public String getNo() {
            return this.no;
        }

        public ConditionDefinition(@NotNull List<String> conditions, boolean type, @NotNull String yes, @NotNull String no) {
            if (conditions == null) {
                throw new NullPointerException("conditions is marked non-null but is null");
            }
            if (yes == null) {
                throw new NullPointerException("yes is marked non-null but is null");
            }
            if (no == null) {
                throw new NullPointerException("no is marked non-null but is null");
            }
            this.conditions = conditions;
            this.type = type;
            this.yes = yes;
            this.no = no;
        }
    }
}

