/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions;

import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleCondition {
    @NotNull
    protected final String leftSide;
    @NotNull
    private final String[] leftSidePlaceholders;
    @NotNull
    protected final String rightSide;
    @NotNull
    private final String[] rightSidePlaceholders;

    protected SimpleCondition(@NotNull String[] arr) {
        this.leftSide = arr.length < 1 ? "" : arr[0];
        this.leftSidePlaceholders = PlaceholderManagerImpl.detectPlaceholders(this.leftSide).toArray(new String[0]);
        this.rightSide = arr.length < 2 ? "" : arr[1];
        this.rightSidePlaceholders = PlaceholderManagerImpl.detectPlaceholders(this.rightSide).toArray(new String[0]);
    }

    @NotNull
    public String parseLeftSide(@NotNull TabPlayer p) {
        return this.parseSide(p, this.leftSide, this.leftSidePlaceholders);
    }

    @NotNull
    public String parseRightSide(@NotNull TabPlayer p) {
        return this.parseSide(p, this.rightSide, this.rightSidePlaceholders);
    }

    public String parseSide(@NotNull TabPlayer p, @NotNull String value, @NotNull String[] placeholders) {
        String result = value;
        for (String identifier : placeholders) {
            result = TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier).set(result, p);
        }
        return EnumChatFormat.color(result);
    }

    public abstract boolean isMet(@NotNull TabPlayer var1);
}

