/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform;

import java.io.File;
import java.util.ConcurrentModificationException;
import me.neznamy.tab.api.integration.VanishIntegration;
import me.neznamy.tab.shared.GroupManager;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Platform {
    @NotNull
    public GroupManager detectPermissionPlugin();

    public void registerUnknownPlaceholder(@NotNull String var1);

    public void loadPlayers();

    public void registerPlaceholders();

    @Nullable
    public PipelineInjector createPipelineInjector();

    @NotNull
    public TabExpansion createTabExpansion();

    @Nullable
    public RedisSupport getRedisSupport();

    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration var1);

    public void logInfo(@NotNull TabComponent var1);

    public void logWarn(@NotNull TabComponent var1);

    public String getServerVersionInfo();

    public void registerListener();

    public void registerCommand();

    public void startMetrics();

    public File getDataFolder();

    public boolean isProxy();

    @NotNull
    public Object convertComponent(@NotNull TabComponent var1, boolean var2);

    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer var1);

    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer var1);

    @NotNull
    public TabList createTabList(@NotNull TabPlayer var1);

    public boolean supportsNumberFormat();

    public boolean supportsListOrder();

    default public boolean canSee(@NotNull TabPlayer viewer, @NotNull TabPlayer target) {
        if (!VanishIntegration.getHandlers().isEmpty()) {
            try {
                return VanishIntegration.getHandlers().stream().allMatch(integration -> integration.canSee(viewer, target));
            }
            catch (ConcurrentModificationException e) {
                return this.canSee(viewer, target);
            }
        }
        return !target.isVanished() || viewer.hasPermission("tab.seevanished");
    }
}

