/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Scoreboard {
    public void registerObjective(@NonNull DisplaySlot var1, @NonNull String var2, @NonNull TabComponent var3, @NonNull HealthDisplay var4, @Nullable TabComponent var5);

    public void unregisterObjective(@NonNull String var1);

    public void updateObjective(@NonNull String var1, @NonNull TabComponent var2, HealthDisplay var3, @Nullable TabComponent var4);

    public void setScore(@NonNull String var1, @NonNull String var2, int var3, @Nullable TabComponent var4, @Nullable TabComponent var5);

    public void removeScore(@NonNull String var1, @NonNull String var2);

    public void registerTeam(@NonNull String var1, @NonNull TabComponent var2, @NonNull TabComponent var3, @NonNull NameVisibility var4, @NonNull CollisionRule var5, @NonNull Collection<String> var6, int var7, @NonNull EnumChatFormat var8);

    public void unregisterTeam(@NonNull String var1);

    public void updateTeam(@NonNull String var1, @NonNull TabComponent var2, @NonNull TabComponent var3, @NonNull NameVisibility var4, @NonNull CollisionRule var5, int var6, @NonNull EnumChatFormat var7);

    public void updateTeam(@NonNull String var1, @NonNull TabComponent var2, @NonNull TabComponent var3, @NonNull EnumChatFormat var4);

    public void updateTeam(@NonNull String var1, @NonNull CollisionRule var2);

    public void updateTeam(@NonNull String var1, @NonNull NameVisibility var2);

    public void renameTeam(@NonNull String var1, @NonNull String var2);

    public void resend();

    public void clear();

    public static class TeamAction {
        public static final int CREATE = 0;
        public static final int REMOVE = 1;
        public static final int UPDATE = 2;
        public static final int ADD_PLAYER = 3;
        public static final int REMOVE_PLAYER = 4;
    }

    public static class ScoreAction {
        public static final int CHANGE = 0;
        public static final int REMOVE = 1;
    }

    public static enum DisplaySlot {
        PLAYER_LIST,
        SIDEBAR,
        BELOW_NAME;

    }

    public static enum HealthDisplay {
        INTEGER,
        HEARTS;

    }

    public static class ObjectiveAction {
        public static final int REGISTER = 0;
        public static final int UNREGISTER = 1;
        public static final int UPDATE = 2;
    }

    public static enum NameVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        private static final Map<String, NameVisibility> BY_NAME;
        private final String string;

        public String toString() {
            return this.string;
        }

        public static NameVisibility getByName(String name) {
            return BY_NAME.getOrDefault(name, ALWAYS);
        }

        private NameVisibility(String string2) {
            this.string = string2;
        }

        static {
            BY_NAME = Arrays.stream(NameVisibility.values()).collect(Collectors.toMap(visibility -> visibility.string, visibility -> visibility));
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        private static final Map<String, CollisionRule> BY_NAME;
        private final String string;

        public String toString() {
            return this.string;
        }

        @NotNull
        public static CollisionRule getByName(@NotNull String name) {
            return BY_NAME.getOrDefault(name, ALWAYS);
        }

        private CollisionRule(String string2) {
            this.string = string2;
        }

        static {
            BY_NAME = Arrays.stream(CollisionRule.values()).collect(Collectors.toMap(collisionRule -> collisionRule.string, collisionRule -> collisionRule));
        }
    }
}

