/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform.decorators;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import lombok.NonNull;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.Nullable;

public abstract class TrackedTabList<P extends TabPlayer, C>
implements TabList {
    protected final P player;
    private boolean antiOverride;
    private final Map<UUID, C> expectedDisplayNames = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable TabComponent displayName) {
        Object component;
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        Object v = component = displayName == null ? null : (Object)this.toComponent(displayName);
        if (this.antiOverride) {
            this.expectedDisplayNames.put(entry, component);
        }
        this.updateDisplayName(entry, component);
    }

    @Override
    public void addEntry(@NonNull TabList.Entry entry) {
        C component;
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        C c = component = entry.getDisplayName() == null ? null : (C)this.toComponent(entry.getDisplayName());
        if (this.antiOverride) {
            this.expectedDisplayNames.put(entry.getUniqueId(), component);
        }
        this.addEntry(entry.getUniqueId(), entry.getName(), entry.getSkin(), entry.isListed(), entry.getLatency(), entry.getGameMode(), component, entry.getListOrder(), entry.isShowHat());
        if (((TabPlayer)this.player).getVersion().getMinorVersion() == 8) {
            this.updateDisplayName(entry.getUniqueId(), component);
        }
    }

    public void checkDisplayNames() {
    }

    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
    }

    public C toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return (C)component.convert(((TabPlayer)this.player).getVersion());
    }

    public abstract void updateDisplayName(@NonNull UUID var1, @Nullable C var2);

    public abstract void addEntry(@NonNull UUID var1, @NonNull String var2, @Nullable TabList.Skin var3, boolean var4, int var5, int var6, @Nullable C var7, int var8, boolean var9);

    public TrackedTabList(P player) {
        this.player = player;
    }

    public void setAntiOverride(boolean antiOverride) {
        this.antiOverride = antiOverride;
    }

    public boolean isAntiOverride() {
        return this.antiOverride;
    }

    public Map<UUID, C> getExpectedDisplayNames() {
        return this.expectedDisplayNames;
    }
}

