/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.util.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.neznamy.tab.shared.TAB;
import org.jetbrains.annotations.NotNull;

public class Cache<K, V> {
    private int accessCount;
    private final String name;
    private final int cacheSize;
    private final Function<K, V> function;
    private final Map<K, V> cache = new HashMap();

    @NotNull
    public synchronized V get(@NotNull K key) {
        ++this.accessCount;
        if (this.cache.size() > this.cacheSize) {
            float efficiency = (float)(this.accessCount - this.cacheSize) / (float)this.accessCount;
            TAB.getInstance().debug("Clearing " + this.name + " cache due to limit (efficiency " + efficiency * 100.0f + "% with " + this.accessCount + " accesses)");
            this.accessCount = 0;
            this.cache.clear();
        }
        return this.cache.computeIfAbsent(key, this.function);
    }

    public Cache(String name, int cacheSize, Function<K, V> function) {
        this.name = name;
        this.cacheSize = cacheSize;
        this.function = function;
    }
}

