/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import me.ethan.eWallet.ECO;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_eWallet
extends AbstractEconomy {
    private final Logger log;
    private final String name = "eWallet";
    private Plugin plugin = null;
    private ECO econ = null;

    public Economy_eWallet(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.econ == null && (econ = plugin.getServer().getPluginManager().getPlugin("eWallet")) != null && econ.isEnabled()) {
            this.econ = (ECO)econ;
            this.log.info(String.format("[Economy] %s hooked.", "eWallet"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.econ != null;
    }

    @Override
    public String getName() {
        return "eWallet";
    }

    @Override
    public String format(double amount) {
        if ((amount = Math.ceil(amount)) == 1.0) {
            return String.format("%d %s", (int)amount, this.econ.singularCurrency);
        }
        return String.format("%d %s", (int)amount, this.econ.pluralCurrency);
    }

    @Override
    public String currencyNameSingular() {
        return this.econ.singularCurrency;
    }

    @Override
    public String currencyNamePlural() {
        return this.econ.pluralCurrency;
    }

    @Override
    public double getBalance(String playerName) {
        Integer i = this.econ.getMoney(playerName);
        return i == null ? 0.0 : (double)i.intValue();
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= Math.ceil(amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        double balance = this.getBalance(playerName);
        if ((amount = Math.ceil(amount)) < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (balance >= amount) {
            double finalBalance = balance - amount;
            this.econ.takeMoney(playerName, Integer.valueOf((int)amount));
            return new EconomyResponse(amount, finalBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        double balance = this.getBalance(playerName);
        if ((amount = Math.ceil(amount)) < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        this.econ.giveMoney(playerName, Integer.valueOf((int)amount));
        return new EconomyResponse(amount, balance += amount, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "eWallet does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.econ.hasAccount(playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        this.econ.createAccount(playerName, Integer.valueOf(0));
        return true;
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_eWallet economy = null;

        public EconomyServerListener(Economy_eWallet economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.econ == null && (eco = event.getPlugin()).getDescription().getName().equals("eWallet")) {
                this.economy.econ = (ECO)eco;
                Economy_eWallet.this.log.info(String.format("[Economy] %s hooked.", "eWallet"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.econ != null && event.getPlugin().getDescription().getName().equals("eWallet")) {
                this.economy.econ = null;
                Economy_eWallet.this.log.info(String.format("[Economy] %s unhooked.", "eWallet"));
            }
        }
    }
}

