/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.api.minecraft.item.data.BlockPredicate;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.util.Copyable;
import com.viaversion.viaversion.util.Rewritable;
import io.netty.buffer.ByteBuf;

public record AdventureModePredicate(BlockPredicate[] predicates, boolean showInTooltip) implements Copyable,
Rewritable
{
    public static final Type<AdventureModePredicate> TYPE1_20_5 = new Type<AdventureModePredicate>(AdventureModePredicate.class){

        @Override
        public AdventureModePredicate read(ByteBuf buffer) {
            BlockPredicate[] predicates = (BlockPredicate[])BlockPredicate.ARRAY_TYPE1_20_5.read(buffer);
            boolean showInTooltip = buffer.readBoolean();
            return new AdventureModePredicate(predicates, showInTooltip);
        }

        @Override
        public void write(ByteBuf buffer, AdventureModePredicate value) {
            BlockPredicate.ARRAY_TYPE1_20_5.write(buffer, value.predicates);
            buffer.writeBoolean(value.showInTooltip);
        }
    };

    public AdventureModePredicate(BlockPredicate[] predicates) {
        this(predicates, true);
    }

    @Override
    public AdventureModePredicate rewrite(UserConnection connection, Protocol<?, ?, ?, ?> protocol, boolean clientbound) {
        BlockPredicate[] predicates = new BlockPredicate[this.predicates.length];
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = this.predicates[i].rewrite(connection, (Protocol)protocol, clientbound);
        }
        return new AdventureModePredicate(predicates, this.showInTooltip);
    }

    @Override
    public AdventureModePredicate copy() {
        return new AdventureModePredicate(Copyable.copy(this.predicates), this.showInTooltip);
    }

    public static final class AdventureModePredicateType1_21_5
    extends Type<AdventureModePredicate> {
        private final Type<BlockPredicate[]> blockPredicateType;

        public AdventureModePredicateType1_21_5(Type<StructuredData<?>[]> dataArrayType) {
            super(AdventureModePredicate.class);
            this.blockPredicateType = new ArrayType<BlockPredicate>(new BlockPredicate.BlockPredicateType1_21_5(dataArrayType));
        }

        @Override
        public AdventureModePredicate read(ByteBuf buffer) {
            BlockPredicate[] predicates = (BlockPredicate[])this.blockPredicateType.read(buffer);
            return new AdventureModePredicate(predicates);
        }

        @Override
        public void write(ByteBuf buffer, AdventureModePredicate value) {
            this.blockPredicateType.write(buffer, value.predicates);
        }
    }
}

