/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.Rewritable;
import io.netty.buffer.ByteBuf;

public record ItemModel(Key key) implements Rewritable
{
    public static final Type<ItemModel> TYPE = new Type<ItemModel>(ItemModel.class){

        @Override
        public ItemModel read(ByteBuf buffer) {
            Key key = (Key)Types.RESOURCE_LOCATION.read(buffer);
            return new ItemModel(key);
        }

        @Override
        public void write(ByteBuf buffer, ItemModel value) {
            Types.RESOURCE_LOCATION.write(buffer, value.key());
        }

        @Override
        public void write(Ops ops, ItemModel data) {
            ops.write(Types.RESOURCE_LOCATION, data.key());
        }
    };

    @Override
    public ItemModel rewrite(UserConnection connection, Protocol<?, ?, ?, ?> protocol, boolean clientbound) {
        String type = this.key().toString();
        String mappedType = Rewritable.rewriteItem(protocol, clientbound, type);
        return mappedType == null || type.equals(mappedType) ? this : new ItemModel(Key.of(mappedType));
    }
}

