/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.cookiePlugin.zcore.utils.xseries;

import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.XReflection;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.MethodMemberHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftClassHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftConnection;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftMapping;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftPackage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;

public class XWorldBorder
implements Cloneable {
    private static final MethodHandle WORLD_HANDLE;
    private static final MethodHandle WORLDBORDER;
    private static final MethodHandle WORLDBORDER_WORLD;
    private static final MethodHandle CENTER;
    private static final MethodHandle WARNING_DISTANCE;
    private static final MethodHandle WARNING_TIME;
    private static final MethodHandle SIZE;
    private static final MethodHandle TRANSITION;
    private static final MethodHandle PACKET_WARNING_DISTANCE;
    private static final MethodHandle PACKET_WARNING_DELAY;
    private static final MethodHandle PACKET_LERP_SIZE;
    private static final MethodHandle PACKET_INIT;
    private static final MethodHandle PACKET_CENTER;
    private static final MethodHandle PACKET_SIZE;
    private static final Object INITIALIZE;
    public static final double MAX_SIZE = 5.9999968E7;
    public static final double MAX_CENTER_COORDINATE = 2.9999984E7;
    private static final boolean SUPPORTS_SEPARATE_PACKETS;
    private static final Map<UUID, XWorldBorder> WORLD_BORDERS;
    private Object handle;
    public int absoluteMaxSize = 29999984;
    private double damagePerBlock = 0.2;
    private double damageSafeZone = 5.0;
    private double size = 100.0;
    private double sizeLerpTarget = 0.0;
    private BorderBounds borderBounds;
    private Duration warningTime = Duration.ofSeconds(15L);
    private Duration sizeLerpTime = Duration.ZERO;
    private int warningBlocks = 5;
    private World world;
    private double centerX;
    private double centerZ;
    private final Set<Component> updateRequired = EnumSet.noneOf(Component.class);
    private UUID player;
    private boolean init = true;

    private XWorldBorder() {
    }

    public static XWorldBorder getOrCreate(Player player) {
        XWorldBorder wb = XWorldBorder.get(player);
        if (wb != null) {
            return wb;
        }
        return XWorldBorder.of(player.getLocation()).setPlayer(player);
    }

    public static XWorldBorder get(Player player) {
        return WORLD_BORDERS.get(player.getUniqueId());
    }

    public XWorldBorder clone() {
        XWorldBorder wb = new XWorldBorder();
        wb.world = this.world;
        wb.centerX = this.centerX;
        wb.centerZ = this.centerZ;
        wb.size = this.size;
        wb.sizeLerpTime = this.sizeLerpTime;
        wb.damagePerBlock = this.damagePerBlock;
        wb.damageSafeZone = this.damageSafeZone;
        wb.warningTime = this.warningTime;
        wb.warningBlocks = this.warningBlocks;
        wb.handle = wb.createHandle();
        wb.player = this.player;
        return wb;
    }

    public static XWorldBorder from(WorldBorder bukkitWb) {
        XWorldBorder wb = new XWorldBorder();
        wb.world = bukkitWb.getCenter().getWorld();
        wb.centerX = bukkitWb.getCenter().getX();
        wb.centerZ = bukkitWb.getCenter().getZ();
        wb.size = bukkitWb.getSize();
        wb.sizeLerpTime = Duration.ZERO;
        wb.damagePerBlock = bukkitWb.getDamageAmount();
        wb.damageSafeZone = bukkitWb.getDamageBuffer();
        wb.warningTime = Duration.ofSeconds(bukkitWb.getWarningTime());
        wb.warningBlocks = bukkitWb.getWarningDistance();
        wb.handle = wb.createHandle();
        return wb;
    }

    @Nullable
    public UUID getPlayerId() {
        return this.player;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)Objects.requireNonNull(this.player, "No player provided"));
    }

    public static XWorldBorder of(Location center) {
        XWorldBorder wb = new XWorldBorder();
        wb.world = Objects.requireNonNull(center.getWorld());
        wb.centerX = center.getX();
        wb.centerZ = center.getZ();
        wb.handle = wb.createHandle();
        wb.update(Component.CENTER);
        return wb;
    }

    public XWorldBorder setDamageAmount(double damage) {
        this.damagePerBlock = damage;
        return this;
    }

    public double getDamageAmount() {
        return this.damagePerBlock;
    }

    public XWorldBorder setDamageBuffer(double blocks) {
        this.damageSafeZone = blocks;
        return this;
    }

    public double getDamageBuffer() {
        return this.damageSafeZone;
    }

    public XWorldBorder setWarningTime(Duration time) {
        if (this.warningTime == time) {
            return this;
        }
        this.warningTime = time;
        this.update(Component.WARNING_DELAY);
        return this;
    }

    public Duration getWarningTime() {
        return this.warningTime;
    }

    public XWorldBorder setWarningDistance(int blocks) {
        if (this.warningBlocks == blocks) {
            return this;
        }
        this.warningBlocks = blocks;
        this.update(Component.WARNING_DISTANCE);
        return this;
    }

    public double getSizeLerpTarget() {
        return this.sizeLerpTarget;
    }

    public XWorldBorder setSizeLerpTarget(double sizeLerpTarget) {
        if (this.sizeLerpTarget == sizeLerpTarget) {
            return this;
        }
        this.sizeLerpTarget = sizeLerpTarget;
        this.update(Component.SIZE_LERP);
        return this;
    }

    public int getWarningDistance() {
        return this.warningBlocks;
    }

    public XWorldBorder setCenter(double x, double z) {
        if (this.centerX == x && this.centerZ == z) {
            return this;
        }
        this.centerX = x;
        this.centerZ = z;
        this.updateBorderBounds();
        this.update(Component.CENTER);
        return this;
    }

    public Vector getCenter() {
        return new Vector(this.centerX, 0.0, this.centerZ);
    }

    public XWorldBorder setSize(double newSize, @Nonnull Duration duration) {
        if (this.size == newSize && this.sizeLerpTime == duration) {
            return this;
        }
        this.size = newSize;
        this.sizeLerpTime = duration;
        this.updateBorderBounds();
        this.update(Component.SIZE);
        if (Duration.ZERO != duration) {
            this.update(Component.SIZE_LERP);
        }
        return this;
    }

    private void updateBorderBounds() {
        this.borderBounds = this.size <= 0.0 ? null : new BorderBounds();
    }

    private void update(Component comp) {
        if (SUPPORTS_SEPARATE_PACKETS) {
            this.updateRequired.add(comp);
        }
    }

    public boolean isWithinBorder(Vector location) {
        if (this.borderBounds == null) {
            return false;
        }
        return location.getX() + 1.0 > this.borderBounds.minX && location.getX() < this.borderBounds.maxX && location.getZ() + 1.0 > this.borderBounds.minZ && location.getZ() < this.borderBounds.maxZ;
    }

    public double getDistanceToBorder(Vector location) {
        if (this.borderBounds == null) {
            return this.getCenter().distanceSquared(location);
        }
        double x = location.getX();
        double z = location.getZ();
        double d2 = z - this.borderBounds.minZ;
        double d3 = this.borderBounds.maxZ - z;
        double d4 = x - this.borderBounds.minX;
        double d5 = this.borderBounds.maxX - x;
        double d6 = Math.min(d4, d5);
        d6 = Math.min(d6, d2);
        return Math.min(d6, d3);
    }

    public void remove() {
        WORLD_BORDERS.remove(this.player);
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        WorldBorder wb = player.getWorld().getWorldBorder();
        XWorldBorder.from(wb).setPlayer(player).send(true);
    }

    public static void remove(Player player) {
        XWorldBorder wb = XWorldBorder.get(player);
        if (wb == null) {
            return;
        }
        wb.remove();
    }

    public XWorldBorder setPlayer(Player player) {
        if (player.getUniqueId().equals(this.player)) {
            return this;
        }
        WORLD_BORDERS.remove(this.player, this);
        WORLD_BORDERS.put(player.getUniqueId(), this);
        this.player = player.getUniqueId();
        this.init = true;
        return this;
    }

    public XWorldBorder send() {
        return this.send(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWorldBorder send(boolean forceInit) {
        Player player = this.getPlayer();
        if (player == null) {
            return this;
        }
        boolean init = forceInit || this.init;
        this.init = false;
        try {
            if (SUPPORTS_SEPARATE_PACKETS && !init) {
                Object[] packets = new Object[this.updateRequired.size()];
                int i = 0;
                for (Component component : this.updateRequired) {
                    component.setHandle(this);
                    packets[i++] = component.createPacket(this);
                }
                MinecraftConnection.sendPacket(player, packets);
            } else {
                for (Component component : this.updateRequired) {
                    component.setHandle(this);
                }
                Object packet = XReflection.supports(17) ? PACKET_INIT.invoke(this.handle) : PACKET_INIT.invoke(this.handle, INITIALIZE);
                MinecraftConnection.sendPacket(player, packet);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.updateRequired.clear();
        }
        return this;
    }

    private Object createHandle() {
        Objects.requireNonNull(this.world, "No world specified");
        try {
            Object worldBorder = WORLDBORDER.invoke();
            Object world = WORLD_HANDLE.invoke(this.world);
            WORLDBORDER_WORLD.invoke(worldBorder, world);
            return worldBorder;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    static {
        boolean supportsSeperatePackets;
        MinecraftClassHandle craftWorld;
        MinecraftClassHandle worldServer;
        MinecraftClassHandle wb;
        MethodHandle packetSize;
        MethodHandle packetCenter;
        MethodHandle packetLerpSize;
        MethodHandle packetWarnDelay;
        MethodHandle packetWarnDist;
        MethodHandle packetInit;
        Object initialize;
        block7: {
            WORLD_BORDERS = new HashMap<UUID, XWorldBorder>();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            initialize = null;
            Object world = null;
            Object worldborder = null;
            Object worldborderWorld = null;
            Object center = null;
            Object distance = null;
            Object warnTime = null;
            Object size = null;
            Object transition = null;
            packetInit = null;
            packetWarnDist = null;
            packetWarnDelay = null;
            packetLerpSize = null;
            packetCenter = null;
            packetSize = null;
            wb = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.border").named("WorldBorder");
            worldServer = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerLevel").map(MinecraftMapping.SPIGOT, "WorldServer");
            craftWorld = XReflection.ofMinecraft().inPackage(MinecraftPackage.CB).named("CraftWorld");
            try {
                Class wbType;
                if (XReflection.supports(17)) break block7;
                try {
                    wbType = Class.forName("EnumWorldBorderAction");
                }
                catch (ClassNotFoundException e) {
                    wbType = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("PacketPlayOutWorldBorder$EnumWorldBorderAction").unreflect();
                }
                packetInit = lookup.findConstructor((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("PacketPlayOutWorldBorder").unreflect(), MethodType.methodType(Void.TYPE, wb.reflect(), new Class[]{wbType}));
                for (Object type : wbType.getEnumConstants()) {
                    if (!type.toString().equals("INITIALIZE")) continue;
                    initialize = type;
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            Function<String, MethodHandle> getPacket = packet -> {
                try {
                    return XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").named((String)packet).constructor(wb).reflect();
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
            packetWarnDist = getPacket.apply("ClientboundSetBorderWarningDistancePacket");
            packetWarnDelay = getPacket.apply("ClientboundSetBorderWarningDelayPacket");
            packetLerpSize = getPacket.apply("ClientboundSetBorderLerpSizePacket");
            packetInit = getPacket.apply("ClientboundInitializeBorderPacket");
            packetCenter = getPacket.apply("ClientboundSetBorderCenterPacket");
            packetSize = getPacket.apply("ClientboundSetBorderSizePacket");
            supportsSeperatePackets = true;
        }
        catch (Throwable ignored) {
            supportsSeperatePackets = false;
        }
        PACKET_INIT = packetInit;
        PACKET_SIZE = packetSize;
        PACKET_CENTER = packetCenter;
        PACKET_LERP_SIZE = packetLerpSize;
        PACKET_WARNING_DELAY = packetWarnDelay;
        PACKET_WARNING_DISTANCE = packetWarnDist;
        SUPPORTS_SEPARATE_PACKETS = supportsSeperatePackets;
        WORLD_HANDLE = (MethodHandle)craftWorld.method().named("getHandle").returns(worldServer).unreflect();
        INITIALIZE = initialize;
        WORLDBORDER = (MethodHandle)wb.constructor().unreflect();
        WORLDBORDER_WORLD = (MethodHandle)wb.field().setter().named("world").returns(worldServer).unreflect();
        CENTER = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "c").orElse("setCenter")).returns((Class)Void.TYPE)).parameters(Double.TYPE, Double.TYPE).unreflect();
        SIZE = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "a").orElse("setSize")).returns((Class)Void.TYPE)).parameters(Double.TYPE).unreflect();
        WARNING_TIME = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "b").orElse("setWarningTime")).returns((Class)Void.TYPE)).parameters(Integer.TYPE).unreflect();
        WARNING_DISTANCE = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(20, "c").v(18, "b").orElse("setWarningDistance")).returns((Class)Void.TYPE)).parameters(Integer.TYPE).unreflect();
        TRANSITION = (MethodHandle)((MethodMemberHandle)wb.method().named(XReflection.v(18, "a").orElse("transitionSizeBetween")).returns((Class)Void.TYPE)).parameters(Double.TYPE, Double.TYPE, Long.TYPE).unreflect();
    }

    private static enum Component {
        SIZE{

            @Override
            protected void setHandle(XWorldBorder wb) throws Throwable {
                SIZE.invoke(wb.handle, wb.size);
            }

            @Override
            protected Object createPacket(XWorldBorder wb) throws Throwable {
                return PACKET_SIZE.invoke(wb.handle);
            }
        }
        ,
        SIZE_LERP{

            @Override
            protected void setHandle(XWorldBorder wb) throws Throwable {
                TRANSITION.invoke(wb.handle, wb.sizeLerpTarget, wb.size, wb.sizeLerpTime.toMillis());
            }

            @Override
            protected Object createPacket(XWorldBorder wb) throws Throwable {
                return PACKET_LERP_SIZE.invoke(wb.handle);
            }
        }
        ,
        WARNING_DISTANCE{

            @Override
            protected void setHandle(XWorldBorder wb) throws Throwable {
                WARNING_DISTANCE.invoke(wb.handle, wb.warningBlocks);
            }

            @Override
            protected Object createPacket(XWorldBorder wb) throws Throwable {
                return PACKET_WARNING_DISTANCE.invoke(wb.handle);
            }
        }
        ,
        WARNING_DELAY{

            @Override
            protected void setHandle(XWorldBorder wb) throws Throwable {
                WARNING_TIME.invoke(wb.handle, wb.warningBlocks);
            }

            @Override
            protected Object createPacket(XWorldBorder wb) throws Throwable {
                return PACKET_WARNING_DELAY.invoke(wb.handle);
            }
        }
        ,
        CENTER{

            @Override
            protected void setHandle(XWorldBorder wb) throws Throwable {
                CENTER.invoke(wb.handle, wb.centerX, wb.centerZ);
            }

            @Override
            protected Object createPacket(XWorldBorder wb) throws Throwable {
                return PACKET_CENTER.invoke(wb.handle);
            }
        };


        protected abstract void setHandle(XWorldBorder var1) throws Throwable;

        protected abstract Object createPacket(XWorldBorder var1) throws Throwable;
    }

    private final class BorderBounds {
        public final double minX;
        public final double minZ;
        public final double maxX;
        public final double maxZ;

        private double clamp(double var0, double var2, double var4) {
            return var0 < var2 ? var2 : Math.min(var0, var4);
        }

        public BorderBounds() {
            this.minX = this.clamp(XWorldBorder.this.centerX - XWorldBorder.this.size / 2.0, -XWorldBorder.this.absoluteMaxSize, XWorldBorder.this.absoluteMaxSize);
            this.minZ = this.clamp(XWorldBorder.this.centerZ - XWorldBorder.this.size / 2.0, -XWorldBorder.this.absoluteMaxSize, XWorldBorder.this.absoluteMaxSize);
            this.maxX = this.clamp(XWorldBorder.this.centerX + XWorldBorder.this.size / 2.0, -XWorldBorder.this.absoluteMaxSize, XWorldBorder.this.absoluteMaxSize);
            this.maxZ = this.clamp(XWorldBorder.this.centerZ + XWorldBorder.this.size / 2.0, -XWorldBorder.this.absoluteMaxSize, XWorldBorder.this.absoluteMaxSize);
        }
    }

    public static final class Events
    implements Listener {
        @EventHandler
        public void onJoin(PlayerMoveEvent event) {
            XWorldBorder wb = XWorldBorder.get(event.getPlayer());
            if (wb == null) {
                return;
            }
            Player p = event.getPlayer();
            Vector loc = p.getLocation().toVector();
            if (wb.isWithinBorder(loc)) {
                return;
            }
            double distance = wb.getDistanceToBorder(loc);
            if (distance < wb.damageSafeZone) {
                return;
            }
            p.damage(wb.damagePerBlock * distance);
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            XWorldBorder wb = XWorldBorder.get(event.getPlayer());
            if (wb == null) {
                return;
            }
            wb.send(true);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onWorldChange(PlayerChangedWorldEvent event) {
            XWorldBorder wb = XWorldBorder.get(event.getPlayer());
            if (wb == null) {
                return;
            }
            wb.send(true);
        }
    }
}

