/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection;

import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.AggregateReflectiveHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.ReflectiveHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.ReflectiveNamespace;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.VersionHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.classes.DynamicClassHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.classes.StaticClassHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftClassHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftMapping;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.minecraft.MinecraftPackage;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.ApiStatus;

public final class XReflection {
    @Nullable
    @ApiStatus.Internal
    public static final String NMS_VERSION = XReflection.findNMSVersionString();
    @ApiStatus.Internal
    public static final String XSERIES_VERSION = "11.2.0";
    public static final int MAJOR_NUMBER;
    public static final int MINOR_NUMBER;
    public static final int PATCH_NUMBER;
    @ApiStatus.Internal
    public static final String CRAFTBUKKIT_PACKAGE;
    @ApiStatus.Internal
    public static final String NMS_PACKAGE;
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static final Set<MinecraftMapping> SUPPORTED_MAPPINGS;

    @Nullable
    @ApiStatus.Internal
    public static String findNMSVersionString() {
        String found = null;
        for (Package pack : Package.getPackages()) {
            String name = pack.getName();
            if (!name.startsWith("org.bukkit.craftbukkit.v")) continue;
            found = pack.getName().split("\\.")[3];
            try {
                Class.forName("org.bukkit.craftbukkit." + found + ".entity.CraftPlayer");
                break;
            }
            catch (ClassNotFoundException e) {
                found = null;
            }
        }
        return found;
    }

    public static String getVersionInformation() {
        return "(NMS: " + (NMS_VERSION == null ? "Unknown NMS" : NMS_VERSION) + " | Parsed: " + MAJOR_NUMBER + '.' + MINOR_NUMBER + '.' + PATCH_NUMBER + " | Minecraft: " + Bukkit.getVersion() + " | Bukkit: " + Bukkit.getBukkitVersion() + ')';
    }

    @Nullable
    public static Integer getLatestPatchNumberOf(int minorVersion) {
        if (minorVersion <= 0) {
            throw new IllegalArgumentException("Minor version must be positive: " + minorVersion);
        }
        int[] patches = new int[]{1, 5, 2, 7, 2, 4, 10, 8, 4, 2, 2, 2, 2, 4, 2, 5, 1, 2, 4, 6, 1};
        if (minorVersion > patches.length) {
            return null;
        }
        return patches[minorVersion - 1];
    }

    private XReflection() {
    }

    public static <T> VersionHandle<T> v(int version, T handle) {
        return new VersionHandle<T>(version, handle);
    }

    public static <T> VersionHandle<T> v(int version, int patch, T handle) {
        return new VersionHandle<T>(version, patch, handle);
    }

    public static <T> VersionHandle<T> v(int version, Callable<T> handle) {
        return new VersionHandle<T>(version, handle);
    }

    public static <T> VersionHandle<T> v(int version, int patch, Callable<T> handle) {
        return new VersionHandle<T>(version, patch, handle);
    }

    public static boolean supports(int minorNumber) {
        return MINOR_NUMBER >= minorNumber;
    }

    public static boolean supports(int majorNumber, int minorNumber, int patchNumber) {
        if (majorNumber != 1) {
            throw new IllegalArgumentException("Invalid major number: " + majorNumber);
        }
        return XReflection.supports(minorNumber, patchNumber);
    }

    public static boolean supports(int minorNumber, int patchNumber) {
        return MINOR_NUMBER == minorNumber ? PATCH_NUMBER >= patchNumber : XReflection.supports(minorNumber);
    }

    @Deprecated
    public static boolean supportsPatch(int patchNumber) {
        return PATCH_NUMBER >= patchNumber;
    }

    @Nonnull
    @Deprecated
    public static Class<?> getNMSClass(@Nullable String packageName, @Nonnull String name) {
        if (packageName != null && XReflection.supports(17)) {
            name = packageName + '.' + name;
        }
        try {
            return Class.forName(NMS_PACKAGE + '.' + name);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    @Deprecated
    public static Class<?> getNMSClass(@Nonnull String name) {
        return XReflection.getNMSClass(null, name);
    }

    @Nonnull
    @Deprecated
    public static Class<?> getCraftClass(@Nonnull String name) {
        try {
            return Class.forName(CRAFTBUKKIT_PACKAGE + '.' + name);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public static Class<?> toArrayClass(Class<?> clazz) {
        try {
            return Class.forName("[L" + clazz.getName() + ';');
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot find array class for class: " + clazz, ex);
        }
    }

    public static MinecraftClassHandle ofMinecraft() {
        return new MinecraftClassHandle(new ReflectiveNamespace());
    }

    public static DynamicClassHandle classHandle() {
        return new DynamicClassHandle(new ReflectiveNamespace());
    }

    public static StaticClassHandle of(Class<?> clazz) {
        return new StaticClassHandle(new ReflectiveNamespace(), clazz);
    }

    public static ReflectiveNamespace namespaced() {
        return new ReflectiveNamespace();
    }

    @SafeVarargs
    public static <T, H extends ReflectiveHandle<T>> AggregateReflectiveHandle<T, H> any(H ... handles) {
        return new AggregateReflectiveHandle(Arrays.stream(handles).map(x -> () -> x).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T, H extends ReflectiveHandle<T>> AggregateReflectiveHandle<T, H> anyOf(Callable<H> ... handles) {
        return new AggregateReflectiveHandle(Arrays.asList(handles));
    }

    @ApiStatus.Experimental
    public static <T extends Throwable> T relativizeSuppressedExceptions(T ex) {
        Objects.requireNonNull(ex, "Cannot relativize null exception");
        StackTraceElement[] EMPTY_STACK_TRACE_ARRAY = new StackTraceElement[]{};
        StackTraceElement[] mainStackTrace = ex.getStackTrace();
        for (Throwable suppressed : ex.getSuppressed()) {
            StackTraceElement[] suppressedStackTrace = suppressed.getStackTrace();
            ArrayList<StackTraceElement> relativized = new ArrayList<StackTraceElement>(10);
            for (int i = 0; i < suppressedStackTrace.length; ++i) {
                if (mainStackTrace.length <= i) {
                    relativized = null;
                    break;
                }
                StackTraceElement mainTrace = mainStackTrace[i];
                StackTraceElement suppTrace = suppressedStackTrace[i];
                if (mainTrace.equals(suppTrace)) break;
                relativized.add(suppTrace);
            }
            if (relativized == null) continue;
            suppressed.setStackTrace(relativized.toArray(EMPTY_STACK_TRACE_ARRAY));
        }
        return ex;
    }

    private static <T extends Throwable> void throwException(Throwable exception) throws T {
        throw exception;
    }

    public static RuntimeException throwCheckedException(Throwable exception) {
        Objects.requireNonNull(exception, "Cannot throw null exception");
        XReflection.throwException(exception);
        return null;
    }

    @ApiStatus.Experimental
    public static <T> CompletableFuture<T> stacktrace(@Nonnull CompletableFuture<T> completableFuture) {
        StackTraceElement[] currentStacktrace = Thread.currentThread().getStackTrace();
        return completableFuture.whenComplete((value, ex) -> {
            if (ex == null) {
                completableFuture.complete(value);
                return;
            }
            try {
                StackTraceElement[] exStacktrace = ex.getStackTrace();
                if (exStacktrace.length >= 3) {
                    ArrayList<StackTraceElement> clearStacktrace = new ArrayList<StackTraceElement>(Arrays.asList(exStacktrace));
                    Collections.reverse(clearStacktrace);
                    Iterator iter = clearStacktrace.iterator();
                    List<String> watchClassNames = Arrays.asList("java.util.concurrent.CompletableFuture", "java.util.concurrent.ThreadPoolExecutor", "java.util.concurrent.ForkJoinTask", "java.util.concurrent.ForkJoinWorkerThread", "java.util.concurrent.ForkJoinPool");
                    List<String> watchMethodNames = Arrays.asList("postComplete", "encodeThrowable", "completeThrowable", "tryFire", "run", "runWorker", "scan", "exec", "doExec", "topLevelExec", "uniWhenComplete");
                    while (iter.hasNext()) {
                        StackTraceElement stackTraceElement = (StackTraceElement)iter.next();
                        String className = stackTraceElement.getClassName();
                        String methodName = stackTraceElement.getMethodName();
                        if (className.equals(Thread.class.getName())) continue;
                        if (!watchClassNames.stream().anyMatch(className::startsWith)) break;
                        if (!watchMethodNames.stream().anyMatch(methodName::equals)) break;
                        iter.remove();
                    }
                    Collections.reverse(clearStacktrace);
                    exStacktrace = clearStacktrace.toArray(new StackTraceElement[0]);
                }
                StackTraceElement[] finalCurrentStackTrace = (StackTraceElement[])Arrays.stream(currentStacktrace).skip(2L).toArray(StackTraceElement[]::new);
                ex.setStackTrace(XReflection.concatenate(exStacktrace, finalCurrentStackTrace));
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            finally {
                completableFuture.completeExceptionally((Throwable)ex);
            }
        });
    }

    @ApiStatus.Internal
    public static <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    static {
        Matcher bukkitVer = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?").matcher(Bukkit.getBukkitVersion());
        if (bukkitVer.find()) {
            try {
                String patch = bukkitVer.group("patch");
                MAJOR_NUMBER = Integer.parseInt(bukkitVer.group("major"));
                MINOR_NUMBER = Integer.parseInt(bukkitVer.group("minor"));
                PATCH_NUMBER = Integer.parseInt(patch == null || patch.isEmpty() ? "0" : patch);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to parse minor number: " + bukkitVer + ' ' + XReflection.getVersionInformation(), ex);
            }
        } else {
            throw new IllegalStateException("Cannot parse server version: \"" + Bukkit.getBukkitVersion() + '\"');
        }
        CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
        NMS_PACKAGE = XReflection.v(17, "net.minecraft").orElse("net.minecraft.server." + NMS_VERSION);
        if (XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerPlayer").exists()) {
            SUPPORTED_MAPPINGS = EnumSet.of(MinecraftMapping.MOJANG);
        } else if (XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "EntityPlayer").exists()) {
            SUPPORTED_MAPPINGS = EnumSet.of(MinecraftMapping.SPIGOT, MinecraftMapping.OBFUSCATED);
        } else {
            MinecraftClassHandle entityPlayer = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerPlayer").map(MinecraftMapping.SPIGOT, "EntityPlayer");
            throw new RuntimeException("Unknown Minecraft mapping " + XReflection.getVersionInformation(), entityPlayer.catchError());
        }
    }
}

