/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.classes;

import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.ReflectiveHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.ReflectiveNamespace;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.ConstructorMemberHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.EnumMemberHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.FieldMemberHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.MethodMemberHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.NamedReflectiveHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.jvm.classes.DynamicClassHandle;
import fr.maxlego08.cookiePlugin.zcore.utils.xseries.reflection.parser.ReflectionParser;
import java.util.Objects;
import org.intellij.lang.annotations.Language;

public abstract class ClassHandle
implements ReflectiveHandle<Class<?>>,
NamedReflectiveHandle {
    protected final ReflectiveNamespace namespace;

    protected ClassHandle(ReflectiveNamespace namespace) {
        this.namespace = namespace;
        namespace.link(this);
    }

    public abstract ClassHandle asArray(int var1);

    public final ClassHandle asArray() {
        return this.asArray(1);
    }

    public abstract boolean isArray();

    public DynamicClassHandle inner(@Language(value="Java") String declaration) {
        return this.inner(this.namespace.classHandle(declaration));
    }

    public <T extends DynamicClassHandle> T inner(T handle) {
        Objects.requireNonNull(handle, "Inner handle is null");
        if (this == handle) {
            throw new IllegalArgumentException("Same instance: " + this);
        }
        handle.parent = this;
        this.namespace.link(this);
        return handle;
    }

    public int getDimensionCount() {
        int count = -1;
        Class<?> clazz = (Class<?>)this.reflectOrNull();
        if (clazz == null) {
            return count;
        }
        do {
            clazz = clazz.getComponentType();
            ++count;
        } while (clazz != null);
        return count;
    }

    public ReflectiveNamespace getNamespace() {
        return this.namespace;
    }

    public MethodMemberHandle method() {
        return new MethodMemberHandle(this);
    }

    public MethodMemberHandle method(@Language(value="Java") String declaration) {
        return this.createParser(declaration).parseMethod(this.method());
    }

    public EnumMemberHandle enums() {
        return new EnumMemberHandle(this);
    }

    public FieldMemberHandle field() {
        return new FieldMemberHandle(this);
    }

    public FieldMemberHandle field(@Language(value="Java") String declaration) {
        return this.createParser(declaration).parseField(this.field());
    }

    public ConstructorMemberHandle constructor(@Language(value="Java") String declaration) {
        return this.createParser(declaration).parseConstructor(this.constructor());
    }

    public ConstructorMemberHandle constructor() {
        return new ConstructorMemberHandle(this);
    }

    public ConstructorMemberHandle constructor(Class<?> ... parameters) {
        return this.constructor().parameters(parameters);
    }

    public ConstructorMemberHandle constructor(ClassHandle ... parameters) {
        return this.constructor().parameters(parameters);
    }

    private ReflectionParser createParser(@Language(value="Java") String declaration) {
        return new ReflectionParser(declaration).imports(this.namespace);
    }

    public abstract ClassHandle clone();
}

