/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import fr.maxlego08.zitemstacker.ItemStackerPlugin;
import fr.maxlego08.zitemstacker.api.TranslationManager;
import fr.maxlego08.zitemstacker.save.Config;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ZTranslationManager
implements TranslationManager {
    private static final String JSON_URL = "https://raw.githubusercontent.com/Maxlego08/minecraft-assets/1.21/assets/minecraft/lang/_list.json";
    private static final String BASE_URL = "https://raw.githubusercontent.com/Maxlego08/minecraft-assets/1.21/assets/minecraft/lang/";
    private final ItemStackerPlugin plugin;
    private final Map<String, String> translationToKeys = new HashMap<String, String>();
    private final Map<String, String> keyToMaterials = new HashMap<String, String>();
    private final Map<String, String> keyToTranslations = new HashMap<String, String>();
    private Map<Material, String> materialToKeys = new HashMap<Material, String>();

    public ZTranslationManager(ItemStackerPlugin plugin) {
        this.plugin = plugin;
    }

    public static List<String> findMatchingKeys(Map<String, String> map, String searchString) {
        ArrayList<String> matchingKeys = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (!key.contains(searchString)) continue;
            matchingKeys.add(key);
        }
        return matchingKeys;
    }

    @Override
    public void loadTranslations() {
        File folder = new File(this.plugin.getDataFolder(), "langs");
        if (folder.exists()) {
            try {
                this.loadTranslation();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        folder.mkdirs();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                List<String> files = this.fetchFileList();
                this.downloadFiles(files, folder);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        });
    }

    private void loadTranslation() {
        if (Config.language == null) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "langs/" + Config.language + ".json");
        if (!file.exists()) {
            this.plugin.getLogger().severe("File langs/" + Config.language + ".json doesnt exist ! ");
            return;
        }
        this.translationToKeys.clear();
        this.keyToMaterials.clear();
        this.keyToTranslations.clear();
        this.materialToKeys = this.getTranslationMaterials();
        this.materialToKeys.forEach((key, value) -> this.keyToMaterials.put((String)value, key.name()));
        Map map = this.plugin.getPersist().load(Map.class, file);
        map.forEach((k, v) -> {
            if (k instanceof String) {
                String key = (String)k;
                if (v instanceof String) {
                    String value = (String)v;
                    if (key.startsWith("block") || key.startsWith("item")) {
                        this.translationToKeys.put(value.toLowerCase(), key);
                        this.keyToTranslations.put(key, value);
                    }
                }
            }
        });
    }

    private Map<Material, String> getTranslationMaterials() {
        HashMap<Material, String> values = new HashMap<Material, String>();
        for (Material value : Material.values()) {
            values.put(value, value.getTranslationKey());
        }
        return values;
    }

    private List<String> fetchFileList() throws IOException {
        URL url = URI.create(JSON_URL).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(connection.getInputStream()));){
            Gson gson = new Gson();
            JsonData jsonData = (JsonData)gson.fromJson((Reader)reader, JsonData.class);
            List<String> list = jsonData.getFiles();
            return list;
        }
    }

    private void downloadFiles(List<String> files, File folder) {
        Path path = folder.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return;
            }
        }
        for (String fileName : files) {
            String fileUrl = BASE_URL + fileName;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    this.downloadFile(fileUrl, Paths.get(folder.getAbsolutePath(), fileName.replace("_", "-")).toString());
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Failed to download " + fileName + ": " + e.getMessage());
                }
            });
        }
    }

    private void downloadFile(String fileUrl, String destPath) throws IOException {
        URL url = URI.create(fileUrl).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             FileOutputStream fileOutputStream = new FileOutputStream(destPath);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        if (Config.enableDebug) {
            this.plugin.getLogger().info("Download file " + fileUrl + " into " + destPath);
        }
        if (Config.language != null && destPath.contains(Config.language)) {
            this.loadTranslation();
        }
    }

    @Override
    public String replaceValue(String searchValue) {
        String translationKey;
        if (this.translationToKeys.containsKey(searchValue) && (translationKey = this.translationToKeys.get(searchValue)) != null && this.keyToMaterials.containsKey(translationKey)) {
            return this.keyToMaterials.get(translationKey);
        }
        return searchValue;
    }

    @Override
    public String translateItemStack(ItemStack itemStack) {
        String key;
        if (itemStack == null) {
            return "ItemStack is NULL";
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        Material material = itemStack.getType();
        if (this.materialToKeys.containsKey(material) && (key = this.materialToKeys.get(material)) != null && this.keyToTranslations.containsKey(key)) {
            return this.keyToTranslations.get(key);
        }
        String name = material.name().replace("_", " ").toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static class JsonData {
        @SerializedName(value="files")
        private List<String> files;

        JsonData() {
        }

        public List<String> getFiles() {
            return this.files;
        }

        public void setFiles(List<String> files) {
            this.files = files;
        }
    }
}

