/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.command;

import fr.maxlego08.zitemstacker.ItemStackerPlugin;
import fr.maxlego08.zitemstacker.command.VCommand;
import fr.maxlego08.zitemstacker.zcore.enums.Message;
import fr.maxlego08.zitemstacker.zcore.logger.Logger;
import fr.maxlego08.zitemstacker.zcore.utils.ZUtils;
import fr.maxlego08.zitemstacker.zcore.utils.commands.CommandType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class CommandManager
extends ZUtils
implements CommandExecutor,
TabCompleter {
    private static CommandMap commandMap;
    private static Constructor<? extends PluginCommand> constructor;
    private final ItemStackerPlugin plugin;
    private final List<VCommand> commands = new ArrayList<VCommand>();

    public CommandManager(ItemStackerPlugin itemStackPlugin) {
        this.plugin = itemStackPlugin;
    }

    public void validCommands() {
        this.plugin.getLog().log("Loading " + this.getUniqueCommand() + " commands", Logger.LogType.SUCCESS);
        this.commandChecking();
    }

    public VCommand registerCommand(VCommand command) {
        this.commands.add(command);
        return command;
    }

    public VCommand registerCommand(String string, VCommand command) {
        this.commands.add(command.addSubCommand(string));
        this.plugin.getCommand(string).setExecutor((CommandExecutor)this);
        this.plugin.getCommand(string).setTabCompleter((TabCompleter)this);
        return command;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        for (VCommand command : this.commands) {
            CommandType type;
            if (!(command.getSubCommands().contains(cmd.getName().toLowerCase()) ? (args.length == 0 || command.isIgnoreParent()) && command.getParent() == null && !(type = this.processRequirements(command, sender, args)).equals((Object)CommandType.CONTINUE) : args.length >= 1 && command.getParent() != null && this.canExecute(args, cmd.getName().toLowerCase(), command) && !(type = this.processRequirements(command, sender, args)).equals((Object)CommandType.CONTINUE))) continue;
            return true;
        }
        this.message(sender, Message.COMMAND_NO_ARG, new Object[0]);
        return true;
    }

    private boolean canExecute(String[] args, String cmd, VCommand command) {
        for (int index = args.length - 1; index > -1; --index) {
            if (!command.getSubCommands().contains(args[index].toLowerCase())) continue;
            if (command.isIgnoreArgs() && (command.getParent() == null || this.canExecute(args, cmd, command.getParent(), index - 1))) {
                return true;
            }
            if (index < args.length - 1) {
                return false;
            }
            return this.canExecute(args, cmd, command.getParent(), index - 1);
        }
        return false;
    }

    private boolean canExecute(String[] args, String cmd, VCommand command, int index) {
        if (index < 0 && command.getSubCommands().contains(cmd.toLowerCase())) {
            return true;
        }
        if (index < 0) {
            return false;
        }
        if (command.getSubCommands().contains(args[index].toLowerCase())) {
            return this.canExecute(args, cmd, command.getParent(), index - 1);
        }
        return false;
    }

    private CommandType processRequirements(VCommand command, CommandSender sender, String[] strings) {
        if (!(sender instanceof Player) && !command.isConsoleCanUse()) {
            this.message(sender, Message.COMMAND_NO_CONSOLE, new Object[0]);
            return CommandType.DEFAULT;
        }
        if (command.getPermission() == null || this.hasPermission((Permissible)sender, command.getPermission())) {
            if (command.runAsync) {
                super.runAsync((Plugin)this.plugin, () -> {
                    CommandType returnType = command.prePerform(this.plugin, sender, strings);
                    if (returnType == CommandType.SYNTAX_ERROR) {
                        this.message(sender, Message.COMMAND_SYNTAX_ERROR, "%syntax%", command.getSyntax());
                    }
                });
                return CommandType.DEFAULT;
            }
            CommandType returnType = command.prePerform(this.plugin, sender, strings);
            if (returnType == CommandType.SYNTAX_ERROR) {
                this.message(sender, Message.COMMAND_SYNTAX_ERROR, "%syntax%", command.getSyntax());
            }
            return returnType;
        }
        this.message(sender, Message.COMMAND_NO_PERMISSION, new Object[0]);
        return CommandType.DEFAULT;
    }

    public List<VCommand> getCommands() {
        return this.commands;
    }

    private int getUniqueCommand() {
        return (int)this.commands.stream().filter(command -> command.getParent() == null).count();
    }

    public boolean isValid(VCommand command, String commandString) {
        return command.getParent() != null ? this.isValid(command.getParent(), commandString) : command.getSubCommands().contains(commandString.toLowerCase());
    }

    private void commandChecking() {
        this.commands.forEach(command -> {
            if (command.sameSubCommands()) {
                Logger.info(command.toString() + " command to an argument similar to its parent command !", Logger.LogType.ERROR);
                this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
            }
        });
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String str, String[] args) {
        for (VCommand command : this.commands) {
            String[] newArgs;
            if (!(command.getSubCommands().contains(cmd.getName().toLowerCase()) ? args.length == 1 && command.getParent() == null : (newArgs = Arrays.copyOf(args, args.length - 1)).length >= 1 && command.getParent() != null && this.canExecute(newArgs, cmd.getName().toLowerCase(), command))) continue;
            return this.proccessTab(sender, command, args);
        }
        return null;
    }

    private List<String> proccessTab(CommandSender sender, VCommand command, String[] args) {
        CommandType type = command.getTabCompleter();
        if (type.equals((Object)CommandType.DEFAULT)) {
            String startWith = args[args.length - 1];
            ArrayList<String> tabCompleter = new ArrayList<String>();
            for (VCommand vCommand : this.commands) {
                if (vCommand.getParent() == null || vCommand.getParent() != command) continue;
                String cmd = vCommand.getSubCommands().get(0);
                if (vCommand.getPermission() != null && !sender.hasPermission(vCommand.getPermission()) || startWith.length() != 0 && !cmd.startsWith(startWith)) continue;
                tabCompleter.add(cmd);
            }
            return tabCompleter.size() == 0 ? null : tabCompleter;
        }
        if (type.equals((Object)CommandType.SUCCESS)) {
            return command.toTab(this.plugin, sender, args);
        }
        return null;
    }

    public void registerCommand(Plugin plugin, String string, VCommand vCommand, List<String> aliases) {
        try {
            PluginCommand command = constructor.newInstance(new Object[]{string, this.plugin});
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setAliases(aliases);
            this.commands.add(vCommand.addSubCommand(string));
            vCommand.addSubCommand(aliases);
            if (!commandMap.register(command.getName(), plugin.getDescription().getName(), (Command)command)) {
                Logger.info("Unable to add the command " + vCommand.getSyntax());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

