/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.placeholder;

import fr.maxlego08.zitemstacker.ItemStackerPlugin;
import fr.maxlego08.zitemstacker.placeholder.AutoPlaceholder;
import fr.maxlego08.zitemstacker.placeholder.ReturnBiConsumer;
import fr.maxlego08.zitemstacker.placeholder.ReturnConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class LocalPlaceholder {
    private static volatile LocalPlaceholder instance;
    private final Pattern pattern = Pattern.compile("[%]([^%]+)[%]");
    private final List<AutoPlaceholder> autoPlaceholders = new ArrayList<AutoPlaceholder>();
    private ItemStackerPlugin plugin;
    private String prefix = "template";

    private LocalPlaceholder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalPlaceholder getInstance() {
        if (instance != null) return instance;
        Class<LocalPlaceholder> clazz = LocalPlaceholder.class;
        synchronized (LocalPlaceholder.class) {
            if (instance != null) return instance;
            instance = new LocalPlaceholder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String setPlaceholders(Player player, String placeholder) {
        if (placeholder == null || !placeholder.contains("%")) {
            return placeholder;
        }
        String realPrefix = this.prefix + "_";
        Matcher matcher = this.pattern.matcher(placeholder);
        while (matcher.find()) {
            String stringPlaceholder = matcher.group(0);
            String regex = matcher.group(1).replace(realPrefix, "");
            String replace = this.onRequest(player, regex);
            if (replace == null) continue;
            placeholder = placeholder.replace(stringPlaceholder, replace);
        }
        return placeholder;
    }

    public List<String> setPlaceholders(Player player, List<String> lore) {
        return lore == null ? null : lore.stream().map(e -> {
            e = this.setPlaceholders(player, (String)e);
            return e;
        }).collect(Collectors.toList());
    }

    public String onRequest(Player player, String string) {
        Optional<AutoPlaceholder> optional = this.autoPlaceholders.stream().filter(autoPlaceholder -> autoPlaceholder.startsWith(string)).findFirst();
        if (optional.isPresent()) {
            AutoPlaceholder autoPlaceholder2 = optional.get();
            String value = string.replace(autoPlaceholder2.getStartWith(), "");
            return autoPlaceholder2.accept(player, value);
        }
        return null;
    }

    public void register(String startWith, ReturnBiConsumer<Player, String, String> biConsumer) {
        this.autoPlaceholders.add(new AutoPlaceholder(startWith, biConsumer));
    }

    public void register(String startWith, ReturnConsumer<Player, String> biConsumer) {
        this.autoPlaceholders.add(new AutoPlaceholder(startWith, biConsumer));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public ItemStackerPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(ItemStackerPlugin plugin) {
        this.plugin = plugin;
    }
}

