/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.save;

import fr.maxlego08.zitemstacker.zcore.enums.Message;
import fr.maxlego08.zitemstacker.zcore.enums.MessageType;
import fr.maxlego08.zitemstacker.zcore.logger.Logger;
import fr.maxlego08.zitemstacker.zcore.utils.storage.Persist;
import fr.maxlego08.zitemstacker.zcore.utils.storage.Savable;
import fr.maxlego08.zitemstacker.zcore.utils.yaml.YamlUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageLoader
extends YamlUtils
implements Savable {
    private final List<Message> loadedMessages = new ArrayList<Message>();

    public MessageLoader(JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void save(Persist persist) {
        if (persist != null) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        YamlConfiguration configuration = this.getConfig(file);
        for (Message message : Message.values()) {
            String path;
            if (!message.isUse() || configuration.contains(path = message.name().toLowerCase().replace("_", "-"))) continue;
            if (message.getType() != MessageType.TCHAT) {
                configuration.set(path + ".type", (Object)message.getType().name());
            }
            if (message.getType().equals((Object)MessageType.TCHAT) || message.getType().equals((Object)MessageType.ACTION) || message.getType().equals((Object)MessageType.CENTER)) {
                if (message.isMessage()) {
                    if (message.getType() != MessageType.TCHAT) {
                        configuration.set(path + ".messages", this.colorReverse(message.getMessages()));
                        continue;
                    }
                    configuration.set(path, this.colorReverse(message.getMessages()));
                    continue;
                }
                if (message.getType() != MessageType.TCHAT) {
                    configuration.set(path + ".message", (Object)this.colorReverse(message.getMessage()));
                    continue;
                }
                configuration.set(path, (Object)this.colorReverse(message.getMessage()));
                continue;
            }
            if (!message.getType().equals((Object)MessageType.TITLE)) continue;
            configuration.set(path + ".title", (Object)this.colorReverse(message.getTitle()));
            configuration.set(path + ".subtitle", (Object)this.colorReverse(message.getSubTitle()));
            configuration.set(path + ".fadeInTime", (Object)message.getStart());
            configuration.set(path + ".showTime", (Object)message.getTime());
            configuration.set(path + ".fadeOutTime", (Object)message.getEnd());
        }
        try {
            configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.loadMessages(configuration);
    }

    @Override
    public void load(Persist persist) {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            this.save(null);
            return;
        }
        YamlConfiguration configuration = this.getConfig(file);
        this.save(null);
        this.loadMessages(configuration);
    }

    private void loadMessages(YamlConfiguration configuration) {
        this.loadedMessages.clear();
        for (String key : configuration.getKeys(false)) {
            this.loadMessage(configuration, key);
        }
        boolean canSave = false;
        for (Message message : Message.values()) {
            if (this.loadedMessages.contains((Object)message) || !message.isUse()) continue;
            canSave = true;
            break;
        }
        if (canSave) {
            Logger.info("Save the message file, add new settings");
            this.save(null);
        }
    }

    private void loadMessage(YamlConfiguration configuration, String key) {
        try {
            Message message = Message.valueOf(key.toUpperCase().replace("-", "_"));
            if (configuration.contains(key + ".type")) {
                MessageType messageType = MessageType.valueOf(configuration.getString(key + ".type", "TCHAT").toUpperCase());
                message.setType(messageType);
                switch (messageType) {
                    case ACTION: 
                    case TCHAT_AND_ACTION: {
                        message.setMessage(configuration.getString(key + ".message"));
                        break;
                    }
                    case CENTER: 
                    case TCHAT: 
                    case WITHOUT_PREFIX: {
                        List messages = configuration.getStringList(key + ".messages");
                        if (messages.isEmpty()) {
                            message.setMessage(configuration.getString(key + ".message"));
                            break;
                        }
                        message.setMessages(messages);
                        break;
                    }
                    case TITLE: {
                        String title = configuration.getString(key + ".title");
                        String subtitle = configuration.getString(key + ".subtitle");
                        int fadeInTime = configuration.getInt(key + ".fadeInTime");
                        int showTime = configuration.getInt(key + ".showTime");
                        int fadeOutTime = configuration.getInt(key + ".fadeOutTime");
                        HashMap<String, Object> titles = new HashMap<String, Object>();
                        titles.put("title", this.color(title));
                        titles.put("subtitle", this.color(subtitle));
                        titles.put("start", fadeInTime);
                        titles.put("time", showTime);
                        titles.put("end", fadeOutTime);
                        titles.put("isUse", true);
                        message.setTitles(titles);
                        break;
                    }
                }
            } else {
                message.setType(MessageType.TCHAT);
                List messages = configuration.getStringList(key);
                if (messages.isEmpty()) {
                    message.setMessage(configuration.getString(key));
                } else {
                    message.setMessages(messages);
                }
            }
            this.loadedMessages.add(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

