/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.maxlego08.zitemstacker.ItemStackerPlugin;
import fr.maxlego08.zitemstacker.command.CommandManager;
import fr.maxlego08.zitemstacker.command.VCommand;
import fr.maxlego08.zitemstacker.placeholder.LocalPlaceholder;
import fr.maxlego08.zitemstacker.placeholder.Placeholder;
import fr.maxlego08.zitemstacker.zcore.logger.Logger;
import fr.maxlego08.zitemstacker.zcore.utils.gson.LocationAdapter;
import fr.maxlego08.zitemstacker.zcore.utils.gson.PotionEffectAdapter;
import fr.maxlego08.zitemstacker.zcore.utils.plugins.Plugins;
import fr.maxlego08.zitemstacker.zcore.utils.storage.NoReloadable;
import fr.maxlego08.zitemstacker.zcore.utils.storage.Persist;
import fr.maxlego08.zitemstacker.zcore.utils.storage.Savable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public abstract class ZPlugin
extends JavaPlugin {
    private final Logger log = new Logger(this.getDescription().getFullName());
    private final List<Savable> savers = new ArrayList<Savable>();
    protected CommandManager commandManager;
    private Gson gson;
    private Persist persist;
    private long enableTime;

    protected void preEnable() {
        LocalPlaceholder.getInstance().setPlugin((ItemStackerPlugin)this);
        Placeholder.getPlaceholder();
        this.enableTime = System.currentTimeMillis();
        this.log.log("=== ENABLE START ===");
        this.log.log("Plugin Version V<&>c" + this.getDescription().getVersion(), Logger.LogType.INFO);
        this.getDataFolder().mkdirs();
        this.gson = this.getGsonBuilder().create();
        this.persist = new Persist(this);
        this.commandManager = new CommandManager((ItemStackerPlugin)this);
    }

    protected void postEnable() {
        if (this.commandManager != null) {
            this.commandManager.validCommands();
        }
        this.log.log("=== ENABLE DONE <&>7(<&>6" + Math.abs(this.enableTime - System.currentTimeMillis()) + "ms<&>7) <&>e===");
    }

    protected void preDisable() {
        this.enableTime = System.currentTimeMillis();
        this.log.log("=== DISABLE START ===");
    }

    protected void postDisable() {
        this.log.log("=== DISABLE DONE <&>7(<&>6" + Math.abs(this.enableTime - System.currentTimeMillis()) + "ms<&>7) <&>e===");
    }

    public GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().excludeFieldsWithModifiers(new int[]{128, 64}).registerTypeAdapter(PotionEffect.class, (Object)new PotionEffectAdapter(this)).registerTypeAdapter(Location.class, (Object)new LocationAdapter(this));
    }

    public void addListener(Listener listener) {
        if (listener instanceof Savable) {
            this.addSave((Savable)listener);
        }
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void addSave(Savable saver) {
        this.savers.add(saver);
    }

    public Logger getLog() {
        return this.log;
    }

    public Gson getGson() {
        return this.gson;
    }

    public Persist getPersist() {
        return this.persist;
    }

    public List<Savable> getSavers() {
        return this.savers;
    }

    protected <T> T getProvider(Class<T> classz) {
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(classz);
        if (provider == null) {
            this.log.log("Unable to retrieve the provider " + String.valueOf(classz), Logger.LogType.WARNING);
            return null;
        }
        return (T)(provider.getProvider() != null ? provider.getProvider() : null);
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    protected boolean isEnable(Plugins plugins) {
        Plugin plugin = this.getPlugin(plugins);
        return plugin != null && plugin.isEnabled();
    }

    protected Plugin getPlugin(Plugins plugins) {
        return Bukkit.getPluginManager().getPlugin(plugins.getName());
    }

    protected void registerCommand(String command, VCommand vCommand, String ... aliases) {
        this.commandManager.registerCommand((Plugin)this, command, vCommand, Arrays.asList(aliases));
    }

    public void loadFiles() {
        this.savers.forEach(save -> save.load(this.persist));
    }

    public void saveFiles() {
        this.savers.forEach(save -> save.save(this.persist));
    }

    public void reloadFiles() {
        this.savers.forEach(save -> {
            if (!(save instanceof NoReloadable)) {
                save.load(this.persist);
            }
        });
    }
}

