/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.enums;

import fr.maxlego08.zitemstacker.zcore.enums.MessageType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public enum Message {
    PREFIX("&8(&6zItemStacker&8) "),
    INVENTORY_CLONE_NULL("&cThe inventory clone is null!"),
    INVENTORY_OPEN_ERROR("&cAn error occurred with the opening of the inventory &6%id%&c."),
    TIME_DAY("%02d %day% %02d %hour% %02d %minute% %02d %second%"),
    TIME_HOUR("%02d %hour% %02d minute(s) %02d %second%"),
    TIME_MINUTE("%02d %minute% %02d %second%"),
    TIME_SECOND("%02d %second%"),
    FORMAT_SECOND("second"),
    FORMAT_SECONDS("seconds"),
    FORMAT_MINUTE("minute"),
    FORMAT_MINUTES("minutes"),
    FORMAT_HOUR("hour"),
    FORMAT_HOURS("hours"),
    FORMAT_DAY("d"),
    FORMAT_DAYS("days"),
    COMMAND_SYNTAX_ERROR("&cYou must execute the command like this&7: &a%syntax%"),
    COMMAND_NO_PERMISSION("&cYou do not have permission to run this command."),
    COMMAND_NO_CONSOLE("&cOnly one player can execute this command."),
    COMMAND_NO_ARG("&cImpossible to find the command with its arguments."),
    COMMAND_SYNTAX_HELP("&f%syntax% &7\u00bb &7%description%"),
    RELOAD("&aYou have just reloaded the configuration files."),
    DESCRIPTION_RELOAD("Reload configuration files"),
    DESCRIPTION_VERSION("Show plugin version");

    private List<String> messages;
    private String message;
    private Map<String, Object> titles = new HashMap<String, Object>();
    private boolean use = true;
    private MessageType type = MessageType.TCHAT;
    private ItemStack itemStack;

    private Message(String message) {
        this.message = message;
        this.use = true;
    }

    private Message(String title, String subTitle, int a, int b, int c) {
        this.use = true;
        this.titles.put("title", title);
        this.titles.put("subtitle", subTitle);
        this.titles.put("start", a);
        this.titles.put("time", b);
        this.titles.put("end", c);
        this.titles.put("isUse", true);
        this.type = MessageType.TITLE;
    }

    private Message(String ... message) {
        this.messages = Arrays.asList(message);
        this.use = true;
    }

    private Message(MessageType type, String ... message) {
        this.messages = Arrays.asList(message);
        this.use = true;
        this.type = type;
    }

    private Message(MessageType type, String message) {
        this.message = message;
        this.use = true;
        this.type = type;
    }

    private Message(String message, boolean use) {
        this.message = message;
        this.use = use;
    }

    public String getMessage() {
        return this.message;
    }

    public String toMsg() {
        return this.message;
    }

    public String msg() {
        return this.message;
    }

    public boolean isUse() {
        return this.use;
    }

    public List<String> getMessages() {
        return this.messages == null ? Collections.singletonList(this.message) : this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public boolean isMessage() {
        return this.messages != null && this.messages.size() > 1;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTitle() {
        return (String)this.titles.get("title");
    }

    public Map<String, Object> getTitles() {
        return this.titles;
    }

    public void setTitles(Map<String, Object> titles) {
        this.titles = titles;
        this.type = MessageType.TITLE;
    }

    public String getSubTitle() {
        return (String)this.titles.get("subtitle");
    }

    public boolean isTitle() {
        return this.titles.containsKey("title");
    }

    public int getStart() {
        return ((Number)this.titles.get("start")).intValue();
    }

    public int getEnd() {
        return ((Number)this.titles.get("end")).intValue();
    }

    public int getTime() {
        return ((Number)this.titles.get("time")).intValue();
    }

    public boolean isUseTitle() {
        return (Boolean)this.titles.getOrDefault("isUse", "true");
    }

    public String replace(String a, String b) {
        return this.message.replace(a, b);
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

