/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.logger;

import org.bukkit.Bukkit;

public class Logger {
    private final String prefix;
    private static Logger logger;

    public Logger(String prefix) {
        this.prefix = prefix;
        logger = this;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void info(String message, LogType type) {
        Logger.getLogger().log(message, type);
    }

    public static void info(String message) {
        Logger.getLogger().log(message, LogType.INFO);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void log(String message, LogType type) {
        Bukkit.getConsoleSender().sendMessage("\u00a78[\u00a7e" + this.prefix + "\u00a78] " + type.getColor() + this.getColoredMessage(message));
    }

    public void log(String message) {
        Bukkit.getConsoleSender().sendMessage("\u00a78[\u00a7e" + this.prefix + "\u00a78] \u00a7e" + this.getColoredMessage(message));
    }

    public void log(String message, Object ... args) {
        this.log(String.format(message, args));
    }

    public void log(String message, LogType type, Object ... args) {
        this.log(String.format(message, args), type);
    }

    public void log(String[] messages, LogType type) {
        for (String message : messages) {
            this.log(message, type);
        }
    }

    public String getColoredMessage(String message) {
        return message.replace("<&>", "\u00a7");
    }

    public static enum LogType {
        ERROR("\u00a7c"),
        INFO("\u00a77"),
        WARNING("\u00a76"),
        SUCCESS("\u00a72");

        private final String color;

        private LogType(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }
    }
}

