/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils;

import fr.maxlego08.zitemstacker.zcore.enums.Message;
import fr.maxlego08.zitemstacker.zcore.enums.MessageType;
import fr.maxlego08.zitemstacker.zcore.utils.DefaultFontInfo;
import fr.maxlego08.zitemstacker.zcore.utils.LocationUtils;
import fr.maxlego08.zitemstacker.zcore.utils.nms.NmsVersion;
import fr.maxlego08.zitemstacker.zcore.utils.players.ActionBar;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public abstract class MessageUtils
extends LocationUtils {
    private static final int CENTER_PX = 154;

    protected void messageWO(CommandSender player, Message message, Object ... args) {
        player.sendMessage(this.getMessage(message, args));
    }

    protected void messageWO(CommandSender player, String message, Object ... args) {
        player.sendMessage(this.getMessage(message, args));
    }

    protected void message(CommandSender sender, String message, Object ... args) {
        sender.sendMessage(Message.PREFIX.msg() + this.getMessage(message, args));
    }

    private void message(CommandSender sender, String message) {
        sender.sendMessage(this.color(message));
    }

    private void sendTchatMessage(Player player, Message message, Object ... args) {
        if (message.getMessages().size() > 1) {
            message.getMessages().forEach(msg -> this.message((CommandSender)player, this.papi(this.getMessage((String)msg, args), player)));
        } else {
            this.message((CommandSender)player, this.papi((message.getType() == MessageType.WITHOUT_PREFIX ? "" : Message.PREFIX.msg()) + this.getMessage(message, args), player));
        }
    }

    protected void message(CommandSender sender, Message message, Object ... args) {
        if (sender instanceof ConsoleCommandSender) {
            if (!message.getMessages().isEmpty()) {
                message.getMessages().forEach(msg -> this.message(sender, this.getMessage((String)msg, args)));
            } else {
                this.message(sender, Message.PREFIX.msg() + this.getMessage(message, args));
            }
        } else {
            Player player = (Player)sender;
            switch (message.getType()) {
                case CENTER: {
                    if (!message.getMessages().isEmpty()) {
                        message.getMessages().forEach(msg -> sender.sendMessage(this.getCenteredMessage(this.papi(this.getMessage((String)msg, args), player))));
                        break;
                    }
                    sender.sendMessage(this.getCenteredMessage(this.papi(this.getMessage(message, args), player)));
                    break;
                }
                case ACTION: {
                    this.actionMessage(player, message, args);
                    break;
                }
                case TCHAT_AND_ACTION: {
                    this.actionMessage(player, message, args);
                    this.sendTchatMessage(player, message, args);
                    break;
                }
                case TCHAT: 
                case WITHOUT_PREFIX: {
                    this.sendTchatMessage(player, message, args);
                    break;
                }
                case TITLE: {
                    String title = message.getTitle();
                    String subTitle = message.getSubTitle();
                    int fadeInTime = message.getStart();
                    int showTime = message.getTime();
                    int fadeOutTime = message.getEnd();
                    this.title(player, this.papi(this.getMessage(title, args), player), this.papi(this.getMessage(subTitle, args), player), fadeInTime, showTime, fadeOutTime);
                    break;
                }
            }
        }
    }

    protected void broadcast(Message message, Object ... args) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.message((CommandSender)player, message, args);
        }
        this.message((CommandSender)Bukkit.getConsoleSender(), message, args);
    }

    protected void actionMessage(Player player, Message message, Object ... args) {
        ActionBar.sendActionBar(player, this.color(this.papi(this.getMessage(message, args), player)));
    }

    protected String getMessage(Message message, Object ... args) {
        return this.getMessage(message.getMessage(), args);
    }

    protected String getMessage(String message, Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Number of invalid arguments. Arguments must be in pairs.");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i] == null || args[i + 1] == null) {
                throw new IllegalArgumentException("Keys and replacement values must not be null.");
            }
            message = message.replace(args[i].toString(), args[i + 1].toString());
        }
        return message;
    }

    protected final Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3] + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void title(Player player, String title, String subtitle, int fadeInTime, int showTime, int fadeOutTime) {
        if (NmsVersion.nmsVersion.isNewMaterial()) {
            player.sendTitle(title, subtitle, fadeInTime, showTime, fadeOutTime);
            return;
        }
        try {
            Object chatTitle = this.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\": \"" + title + "\"}");
            Constructor<?> titleConstructor = this.getNMSClass("PacketPlayOutTitle").getConstructor(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0], this.getNMSClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object packet = titleConstructor.newInstance(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("TITLE").get(null), chatTitle, fadeInTime, showTime, fadeOutTime);
            Object chatsTitle = this.getNMSClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\": \"" + subtitle + "\"}");
            Constructor<?> timingTitleConstructor = this.getNMSClass("PacketPlayOutTitle").getConstructor(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0], this.getNMSClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object timingPacket = timingTitleConstructor.newInstance(this.getNMSClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("SUBTITLE").get(null), chatsTitle, fadeInTime, showTime, fadeOutTime);
            this.sendPacket(player, packet);
            this.sendPacket(player, timingPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
            playerConnection.getClass().getMethod("sendPacket", this.getNMSClass("Packet")).invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getCenteredMessage(String message) {
        if (message == null || message.equals("")) {
            return "";
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return String.valueOf(sb) + message;
    }

    protected void broadcastCenterMessage(List<String> messages) {
        messages.stream().map(this::getCenteredMessage).forEach(e -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.messageWO((CommandSender)player, (String)e, new Object[0]);
            }
        });
    }

    protected void broadcastAction(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, this.papi(message, player));
        }
    }

    protected String color(String message) {
        if (message == null) {
            return null;
        }
        if (NmsVersion.nmsVersion.isHexVersion()) {
            Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                message = message.replace(color, String.valueOf(net.md_5.bungee.api.ChatColor.of((String)color)));
                matcher = pattern.matcher(message);
            }
        }
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

