/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Pagination<T> {
    public List<T> paginateReverse(List<T> list, int inventorySize, int page) {
        if (page <= 0) {
            page = 1;
        }
        int idStart = Math.max(0, list.size() - (page - 1) * inventorySize - 1);
        int idEnd = Math.max(-1, idStart - inventorySize);
        ArrayList<T> currentList = new ArrayList<T>();
        for (int i = idStart; i > idEnd; --i) {
            currentList.add(list.get(i));
        }
        return currentList;
    }

    public List<T> paginate(List<T> list, int size, int page) {
        if (page <= 0) {
            page = 1;
        }
        int idStart = (page - 1) * size;
        int idEnd = Math.min(list.size(), idStart + size);
        return new ArrayList<T>(list.subList(idStart, idEnd));
    }

    public List<T> paginateReverse(Map<?, T> map, int size, int page) {
        return this.paginateReverse(new ArrayList<T>(new LinkedHashMap(map).values()), size, page);
    }

    public List<T> paginate(Map<?, T> map, int inventorySize, int page) {
        return this.paginate(new ArrayList<T>(new LinkedHashMap(map).values()), inventorySize, page);
    }
}

