/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zitemstacker.zcore.utils;

import com.google.common.base.Strings;
import fr.maxlego08.zitemstacker.zcore.enums.Permission;
import fr.maxlego08.zitemstacker.zcore.utils.MessageUtils;
import fr.maxlego08.zitemstacker.zcore.utils.ProgressBar;
import fr.maxlego08.zitemstacker.zcore.utils.RandomString;
import fr.maxlego08.zitemstacker.zcore.utils.builder.CooldownBuilder;
import fr.maxlego08.zitemstacker.zcore.utils.builder.TimerBuilder;
import fr.maxlego08.zitemstacker.zcore.utils.nms.ItemStackUtils;
import fr.maxlego08.zitemstacker.zcore.utils.nms.NmsVersion;
import fr.maxlego08.zitemstacker.zcore.utils.players.ActionBar;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.potion.PotionEffectType;

public abstract class ZUtils
extends MessageUtils {
    private static Material[] byId;

    protected String encode(ItemStack item) {
        return ItemStackUtils.serializeItemStack(item);
    }

    protected ItemStack decode(String item) {
        return ItemStackUtils.deserializeItemStack(item);
    }

    protected int getNumberBetween(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    protected boolean hasInventoryFull(Player player) {
        int slot = 0;
        PlayerInventory inventory = player.getInventory();
        for (int a = 0; a != 36; ++a) {
            ItemStack itemStack = inventory.getContents()[a];
            if (itemStack != null) continue;
            ++slot;
        }
        return slot == 0;
    }

    protected void give(Player player, ItemStack item) {
        if (this.hasInventoryFull(player)) {
            player.getWorld().dropItem(player.getLocation(), item);
        } else {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }

    protected Material getMaterial(int id) {
        return byId.length > id && id >= 0 ? byId[id] : Material.AIR;
    }

    protected boolean hasDisplayName(ItemStack itemStack) {
        return itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName();
    }

    protected boolean same(ItemStack itemStack, String name) {
        return this.hasDisplayName(itemStack) && itemStack.getItemMeta().getDisplayName().equals(name);
    }

    protected boolean contains(ItemStack itemStack, String name) {
        return this.hasDisplayName(itemStack) && itemStack.getItemMeta().getDisplayName().contains(name);
    }

    protected void removeItemInHand(Player player) {
        this.removeItemInHand(player, 64);
    }

    protected void removeItemInHand(Player player, int how) {
        if (player.getItemInHand().getAmount() > how) {
            player.getItemInHand().setAmount(player.getItemInHand().getAmount() - how);
        } else {
            player.setItemInHand(new ItemStack(Material.AIR));
        }
        player.updateInventory();
    }

    protected boolean same(Location firstLocation, Location secondLocation) {
        return firstLocation.getBlockX() == secondLocation.getBlockX() && firstLocation.getBlockY() == secondLocation.getBlockY() && firstLocation.getBlockZ() == secondLocation.getBlockZ() && firstLocation.getWorld().getName().equals(secondLocation.getWorld().getName());
    }

    protected String format(double decimal) {
        return this.format(decimal, "#.##");
    }

    protected String format(double decimal, String format) {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(decimal);
    }

    protected void removeItems(Player player, int amount, ItemStack itemStack) {
        int slot = 0;
        for (ItemStack is : player.getInventory().getContents()) {
            if (is != null && is.isSimilar(itemStack) && amount > 0) {
                int currentAmount = is.getAmount() - amount;
                amount -= is.getAmount();
                if (currentAmount <= 0) {
                    if (slot == 40) {
                        player.getInventory().setItemInOffHand(null);
                    } else {
                        player.getInventory().removeItem(new ItemStack[]{is});
                    }
                } else {
                    is.setAmount(currentAmount);
                }
            }
            ++slot;
        }
        player.updateInventory();
    }

    protected void schedule(long delay, final Runnable runnable) {
        new Timer().schedule(new TimerTask(this){

            @Override
            public void run() {
                if (runnable != null) {
                    runnable.run();
                }
            }
        }, delay);
    }

    protected String name(String string) {
        String name = string.replace("_", " ").toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected String name(Material string) {
        String name = string.name().replace("_", " ").toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected String name(ItemStack itemStack) {
        if (itemStack == null) {
            return "";
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        String name = itemStack.serialize().get("type").toString().replace("_", " ").toLowerCase();
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected int getMaxPage(Collection<?> items) {
        return items.size() / 45 + 1;
    }

    protected int getMaxPage(Collection<?> items, int a) {
        return items.size() / a + 1;
    }

    protected double percent(double value, double total) {
        return value * 100.0 / total;
    }

    protected double percentNum(double total, double percent) {
        return total * (percent / 100.0);
    }

    protected void schedule(final Plugin plugin, long delay, final int count, final Runnable runnable) {
        new Timer().scheduleAtFixedRate(new TimerTask(this){
            int tmpCount = 0;

            @Override
            public void run() {
                if (!plugin.isEnabled()) {
                    this.cancel();
                    return;
                }
                if (this.tmpCount > count) {
                    this.cancel();
                    return;
                }
                ++this.tmpCount;
                Bukkit.getScheduler().runTask(plugin, runnable);
            }
        }, 0L, delay);
    }

    protected boolean hasPermission(Permissible permissible, Permission permission) {
        return permissible.hasPermission(permission.getPermission());
    }

    protected boolean hasPermission(Permissible permissible, String permission) {
        return permissible.hasPermission(permission);
    }

    protected TimerTask scheduleFix(Plugin plugin, long delay, BiConsumer<TimerTask, Boolean> consumer) {
        return this.scheduleFix(plugin, delay, delay, consumer);
    }

    protected TimerTask scheduleFix(final Plugin plugin, long startAt, long delay, final BiConsumer<TimerTask, Boolean> consumer) {
        TimerTask task = new TimerTask(this){

            @Override
            public void run() {
                if (!plugin.isEnabled()) {
                    this.cancel();
                    consumer.accept(this, false);
                    return;
                }
                Bukkit.getScheduler().runTask(plugin, () -> consumer.accept(this, true));
            }
        };
        new Timer().scheduleAtFixedRate(task, startAt, delay);
        return task;
    }

    protected <T> T randomElement(List<T> elements) {
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Random random = new Random();
        return elements.get(random.nextInt(elements.size()));
    }

    protected String colorReverse(String message) {
        Pattern pattern = Pattern.compile("\u00a7x[a-fA-F0-9-\u00a7]{12}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String color = message.substring(matcher.start(), matcher.end());
            String colorReplace = color.replace("\u00a7x", "#");
            colorReplace = colorReplace.replace("\u00a7", "");
            message = message.replace(color, colorReplace);
            matcher = pattern.matcher(message);
        }
        return message == null ? null : message.replace("\u00a7", "&");
    }

    protected List<String> color(List<String> messages) {
        return messages.stream().map(this::color).collect(Collectors.toList());
    }

    protected List<String> colorReverse(List<String> messages) {
        return messages.stream().map(this::colorReverse).collect(Collectors.toList());
    }

    protected ItemFlag getFlag(String flagString) {
        for (ItemFlag flag : ItemFlag.values()) {
            if (!flag.name().equalsIgnoreCase(flagString)) continue;
            return flag;
        }
        return null;
    }

    protected <T> List<T> reverse(List<T> list) {
        ArrayList<T> tmpList = new ArrayList<T>();
        for (int index = list.size() - 1; index != -1; --index) {
            tmpList.add(list.get(index));
        }
        return tmpList;
    }

    protected String price(long price) {
        return String.format("%,d", price);
    }

    protected String generateRandomString(int length) {
        RandomString randomString = new RandomString(length);
        return randomString.nextString();
    }

    protected TextComponent buildTextComponent(String message) {
        return new TextComponent(message);
    }

    protected TextComponent setHoverMessage(TextComponent component, String ... messages) {
        BaseComponent[] list = new BaseComponent[messages.length];
        for (int a = 0; a != messages.length; ++a) {
            list[a] = new TextComponent(messages[a] + (messages.length - 1 == a ? "" : "\n"));
        }
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, list));
        return component;
    }

    protected TextComponent setHoverMessage(TextComponent component, List<String> messages) {
        BaseComponent[] list = new BaseComponent[messages.size()];
        for (int a = 0; a != messages.size(); ++a) {
            list[a] = new TextComponent(messages.get(a) + (messages.size() - 1 == a ? "" : "\n"));
        }
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, list));
        return component;
    }

    protected TextComponent setClickAction(TextComponent component, ClickEvent.Action action, String command) {
        component.setClickEvent(new ClickEvent(action, command));
        return component;
    }

    protected String getDisplayBalance(double value) {
        if (value < 10000.0) {
            return this.format(value, "#.#");
        }
        if (value < 1000000.0) {
            return (int)(value / 1000.0) + "k ";
        }
        if (value < 1.0E9) {
            return this.format(value / 1000.0 / 1000.0, "#.#") + "m ";
        }
        if (value < 1.0E12) {
            return (int)(value / 1000.0 / 1000.0 / 1000.0) + "M ";
        }
        return "too much";
    }

    protected String getDisplayBalance(long value) {
        if (value < 10000L) {
            return this.format((double)value, "#.#");
        }
        if (value < 1000000L) {
            return (int)(value / 1000L) + "k ";
        }
        if (value < 1000000000L) {
            return this.format((double)(value / 1000L) / 1000.0, "#.#") + "m ";
        }
        if (value < 1000000000000L) {
            return (int)(value / 1000L / 1000L / 1000L) + "M ";
        }
        return "too much";
    }

    protected int count(Inventory inventory, Material material) {
        int count = 0;
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || !itemStack.getType().equals((Object)material)) continue;
            count += itemStack.getAmount();
        }
        return count;
    }

    protected Enchantment enchantFromString(String str) {
        for (Enchantment enchantment : Enchantment.values()) {
            if (!enchantment.getName().equalsIgnoreCase(str)) continue;
            return enchantment;
        }
        return null;
    }

    protected BlockFace getClosestFace(float direction) {
        if ((direction %= 360.0f) < 0.0f) {
            direction += 360.0f;
        }
        direction = Math.round(direction / 45.0f);
        switch ((int)direction) {
            case 1: {
                return BlockFace.NORTH_WEST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH;
            }
            case 7: {
                return BlockFace.SOUTH_WEST;
            }
        }
        return BlockFace.WEST;
    }

    protected String betterPrice(long price) {
        StringBuilder betterPrice = new StringBuilder();
        String[] splitPrice = String.valueOf(price).split("");
        int current = 0;
        for (int a = splitPrice.length - 1; a > -1; --a) {
            if (++current > 3) {
                betterPrice.append(".");
                current = 1;
            }
            betterPrice.append(splitPrice[a]);
        }
        StringBuilder builder = new StringBuilder().append((CharSequence)betterPrice);
        builder.reverse();
        return builder.toString();
    }

    protected boolean hasEnchant(Enchantment enchantment, ItemStack itemStack) {
        return itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants() && itemStack.getItemMeta().hasEnchant(enchantment);
    }

    protected String timerFormat(Player player, String cooldown) {
        return TimerBuilder.getStringTime(CooldownBuilder.getCooldownPlayer(cooldown, player) / 1000L);
    }

    protected boolean isCooldown(Player player, String cooldown) {
        return this.isCooldown(player, cooldown, 0);
    }

    protected boolean isCooldown(Player player, String cooldown, int timer) {
        if (CooldownBuilder.isCooldown(cooldown, player)) {
            ActionBar.sendActionBar(player, String.format("\u00a7cVous devez attendre encore \u00a76%s \u00a7cavant de pouvoir faire cette action.", this.timerFormat(player, cooldown)));
            return true;
        }
        if (timer > 0) {
            CooldownBuilder.addCooldown(cooldown, player, timer);
        }
        return false;
    }

    protected String toList(Stream<String> list) {
        return this.toList(list.collect(Collectors.toList()), "\u00a7e", "\u00a76");
    }

    protected String toList(List<String> list) {
        return this.toList(list, "\u00a7e", "\u00a76\u00a7n");
    }

    protected String toList(List<String> list, String color, String color2) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder str = new StringBuilder();
        for (int a = 0; a != list.size(); ++a) {
            if (a == list.size() - 1) {
                str.append(color).append(" et ").append(color2);
            } else if (a != 0) {
                str.append(color).append(", ").append(color2);
            }
            str.append(list.get(a));
        }
        return str.toString();
    }

    protected String format(long value) {
        return this.format(value, ' ');
    }

    protected String format(long l, char c) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(c);
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(l);
    }

    public ItemStack playerHead(ItemStack itemStack, OfflinePlayer player) {
        String name;
        String string = name = itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : null;
        if (NmsVersion.nmsVersion.isNewMaterial()) {
            if (itemStack.getType().equals((Object)Material.PLAYER_HEAD) && name != null && name.startsWith("HEAD")) {
                SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
                if ((name = name.replace("HEAD", "")).length() == 0) {
                    meta.setDisplayName(null);
                } else {
                    meta.setDisplayName(name);
                }
                meta.setOwningPlayer(player);
                itemStack.setItemMeta((ItemMeta)meta);
            }
        } else if (itemStack.getType().equals((Object)this.getMaterial(397)) && itemStack.getData().getData() == 3 && name != null && name.startsWith("HEAD")) {
            SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
            if ((name = name.replace("HEAD", "")).length() == 0) {
                meta.setDisplayName(null);
            } else {
                meta.setDisplayName(name);
            }
            meta.setOwner(player.getName());
            itemStack.setItemMeta((ItemMeta)meta);
        }
        return itemStack;
    }

    protected ItemStack playerHead() {
        return NmsVersion.nmsVersion.isNewMaterial() ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(this.getMaterial(397), 1, 3);
    }

    protected <T> T getProvider(Plugin plugin, Class<T> classz) {
        RegisteredServiceProvider provider = plugin.getServer().getServicesManager().getRegistration(classz);
        if (provider == null) {
            return null;
        }
        return (T)(provider.getProvider() != null ? provider.getProvider() : null);
    }

    protected PotionEffectType getPotion(String configuration) {
        for (PotionEffectType effectType : PotionEffectType.values()) {
            if (!effectType.getName().equalsIgnoreCase(configuration)) continue;
            return effectType;
        }
        return null;
    }

    protected void runAsync(Plugin plugin, Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously(plugin, runnable);
    }

    protected String getStringTime(long second) {
        return TimerBuilder.getStringTime(second);
    }

    protected boolean isPlayerHead(ItemStack itemStack) {
        Material material = itemStack.getType();
        if (NmsVersion.nmsVersion.isNewMaterial()) {
            return material.equals((Object)Material.PLAYER_HEAD);
        }
        return material.equals((Object)this.getMaterial(397)) && itemStack.getDurability() == 3;
    }

    protected Object getPrivateField(Object object, String field) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field objectField = field.equals("commandMap") ? clazz.getDeclaredField(field) : (field.equals("knownCommands") ? (NmsVersion.nmsVersion.isNewMaterial() ? clazz.getSuperclass().getDeclaredField(field) : clazz.getDeclaredField(field)) : null);
        objectField.setAccessible(true);
        Object result = objectField.get(object);
        objectField.setAccessible(false);
        return result;
    }

    protected void unRegisterBukkitCommand(Plugin plugin, PluginCommand command) {
        try {
            Object result = this.getPrivateField(plugin.getServer().getPluginManager(), "commandMap");
            SimpleCommandMap commandMap = (SimpleCommandMap)result;
            Object map = this.getPrivateField(commandMap, "knownCommands");
            HashMap knownCommands = (HashMap)map;
            knownCommands.remove(command.getName());
            for (String alias : command.getAliases()) {
                knownCommands.remove(alias);
            }
            knownCommands.remove(plugin.getName() + ":" + command.getName());
            for (String alias : command.getAliases()) {
                knownCommands.remove(plugin.getName() + ":" + alias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void clearPlayer(Player player) {
        player.getInventory().clear();
        player.getInventory().setBoots(null);
        player.getInventory().setChestplate(null);
        player.getInventory().setLeggings(null);
        player.getInventory().setHelmet(null);
        player.getPlayer().setItemOnCursor(null);
        player.getPlayer().setFireTicks(0);
        player.getPlayer().getOpenInventory().getTopInventory().clear();
        player.setGameMode(GameMode.SURVIVAL);
        player.getPlayer().getActivePotionEffects().forEach(e -> player.getPlayer().removePotionEffect(e.getType()));
    }

    public String getProgressBar(int current, int max, int totalBars, char symbol, String completedColor, String notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        return Strings.repeat((String)(completedColor + symbol), (int)progressBars) + Strings.repeat((String)(notCompletedColor + symbol), (int)(totalBars - progressBars));
    }

    public String getProgressBar(int current, int max, ProgressBar progressBar) {
        return this.getProgressBar(current, max, progressBar.getLength(), progressBar.getSymbol(), progressBar.getCompletedColor(), progressBar.getNotCompletedColor());
    }

    protected boolean inventoryHasItem(Player player) {
        ItemStack itemStack = player.getInventory().getBoots();
        if (itemStack != null) {
            return true;
        }
        itemStack = player.getInventory().getChestplate();
        if (itemStack != null) {
            return true;
        }
        itemStack = player.getInventory().getLeggings();
        if (itemStack != null) {
            return true;
        }
        itemStack = player.getInventory().getHelmet();
        if (itemStack != null) {
            return true;
        }
        for (ItemStack currentItemStack : player.getInventory().getContents()) {
            if (currentItemStack == null) continue;
            return true;
        }
        return false;
    }

    protected void files(File folder, Consumer<File> consumer) {
        try (Stream<Path> s = Files.walk(Paths.get(folder.getPath(), new String[0]), new FileVisitOption[0]);){
            s.skip(1L).map(Path::toFile).filter(File::isFile).filter(e -> e.getName().endsWith(".yml")).forEach(consumer);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (!NmsVersion.nmsVersion.isNewMaterial()) {
            byId = new Material[0];
            for (Material material : Material.values()) {
                if (byId.length <= material.getId()) {
                    byId = Arrays.copyOfRange(byId, 0, material.getId() + 2);
                }
                ZUtils.byId[material.getId()] = material;
            }
        }
    }
}

